package com.valor.vod.api.model.constant.response;

/**
 * Created by Frank.Huang on 2016/12/14.
 */
public enum EFilmographyJob {
    UNKNOWN,
    DIRECTOR,   //导演
    ACTOR,     //演员
    SOUNDTRACK,//配音
    SELF,     //自己,谈话和访谈节目
    WRITER,//编剧
    PRODUCER,//制片人
    ;

    public static final String IMDB_LABEL_ACTOR = "ACTOR";
    public static final String IMDB_LABEL_ACTRESS = "ACTRESS";
    public static final String IMDB_LABEL_DIRECTOR = "DIRECTOR";
    public static final String IMDB_LABEL_SELF = "SELF";
    public static final String IMDB_LABEL_WRITER = "WRITER";
    public static final String IMDB_LABEL_SOUNDTRACK = "SOUNDTRACK";
    public static final String IMDB_LABEL_PRODUCER = "PRODUCER";


    public static EFilmographyJob valueOfString(String v) {
        if (v == null || v.isEmpty()) {
            return UNKNOWN;
        }

        switch (v.toUpperCase()) {
            case IMDB_LABEL_ACTOR:
            case IMDB_LABEL_ACTRESS:
                return ACTOR;
            case IMDB_LABEL_DIRECTOR:
                return DIRECTOR;
            case IMDB_LABEL_SELF:
                return SELF;
            case IMDB_LABEL_SOUNDTRACK:
                return SOUNDTRACK;
            case IMDB_LABEL_WRITER:
                return WRITER;
            case IMDB_LABEL_PRODUCER:
                return PRODUCER;
            default:
                return UNKNOWN;
        }
    }
}
