package com.valor.vod.api.model.filter;

/**
 * Project     : volor
 * Description :
 * Author      : Frank
 * Create Time : 2016/1/2 10:39
 */
public class FilterHelper {
    public static final String FILTER_GENRE = "genre";
    public static final String FILTER_COUNTRY = "country";
    public static final String FILTER_RATING = "rating";
    public static final String FILTER_NEW_RATING = "new_rating";
    public static final String FILTER_RELEASE_YEAR = "year";
    public static final String FILTER_RELEASE_DATE = "reldate";

    public static final String FILTER_HOLLYWOOD = "isHollywood";
    public static final String FILTER_LATIN = "isLatin";
    public static final String FILTER_ANIMATION = "isAnimation";
    public static final String FILTER_FAMILY = "isFamlly";
    public static final String FILTER_LINKED_TIME = "linkedTime";
    public static final String FILTER_LINKED = "linked";
    public static final String FILTER_ASIA = "isAsia";
    public static final String FILTER_LAST_AIR_DATE = "lastAirDate";//on the air查询时间
    public static final String FILTER_LATEST_INFO_CONFIG = "LatestInfoConfig";//release date标签通用化
    public static final String FILTER_NOT_LANG_EN = "notLangEN";
    public static final String FILTER_TIME_LIMIT = "timeLimit";
    public static final String FILTER_AUDIO_LANG = "audioLang";//音轨
    public static final String FILTER_PLAYLIST_ID = "playlistId";//列表ID

    public static final String FILTER_EQ = "eq"; //  eq 相等（equal）
    public static final String FILTER_NE = "ne"; //  ne 不等（not equal）
    public static final String FILTER_GT = "gt"; //  gt 大于（greater than）
    public static final String FILTER_LT = "lt"; //  lt 小于（less than）
    public static final String FILTER_GE = "ge"; //  ge 大于等于 （greater than or equal）
    public static final String FILTER_LE = "le"; //  le 小于等于 （less than or equal）

    public static final String FILTER_IN = "in";        // in
    public static final String FILTER_NOT_IN = "notin"; // not in

    public static final String SQL_AND = " and ";
    public static final String SQL_EQ = " = ";
    public static final String SQL_NE = " != ";
    public static final String SQL_GT = " > ";
    public static final String SQL_LT = " < ";
    public static final String SQL_GE = " >= ";
    public static final String SQL_LE = " <= ";
    public static final String SQL_IN = " in ";
    public static final String SQL_NOT_IN = " not in ";

    public static String getSqlOperator(String opCode) {
        if (opCode == null) {
            return SQL_EQ;
        }

        switch (opCode.toLowerCase().trim()) {
            case FilterHelper.FILTER_NE:
                return SQL_NE;
            case FilterHelper.FILTER_GT:
                return SQL_GT;
            case FilterHelper.FILTER_LT:
                return SQL_LT;
            case FilterHelper.FILTER_GE:
                return SQL_GE;
            case FilterHelper.FILTER_LE:
                return SQL_LE;
            case FilterHelper.FILTER_IN:
                return SQL_IN;
            case FilterHelper.FILTER_NOT_IN:
                return SQL_NOT_IN;
            default:
                return SQL_EQ;
        }
    }


}
