package com.valor.vod.api.model.notice;


import com.valor.vod.api.model.common.AbstractPrintable;

import java.util.Date;
import java.util.List;

/**
 * File        : valormotorserver:${FILENAME}
 * Description :
 * Author      : Frank
 * Created     : 2015/9/4
 */

public class NoticeDO extends AbstractPrintable {

    private Long noticeId;//
    private String region = "defailt";
    private String language;
    private ENoticeType noticeType;   //类型
    private ENoticeFrequency frequency = ENoticeFrequency.ALWAYS;    //展示频率
    private int priority;     //优先级//
    private String title;        //标题
    private String message;      //消息内容
    private String image;        //图片
    private String url;          //url
    private Long startTime;    //开始时间(格式:yyyymmdd)
    private Long endTime;      //结束时间(格式:yyyymmdd)
    private ENoticeStatus status;
    private String updateTime;
    private String imageChecksum;
    private Date startTime2;
    private Date endTime2;
    private int userType;
    private int loginType;
    private int deviceType;     //设备类型
    private int serviceStatus;
    private String productModel;
    private List<Integer> userGroupIds;
    private EPotalNoticeType potalNoticeType;//
    private String mobileMaxVersion;
    private String mobileMinVersion;
    private String stbMaxVersion;
    private String stbMinVersion;
    private String showType;
    private int listId;
    private String ttId;
    private String noticeSize;
    private String viewImg;
    private Integer bannerToken;

    private int linkType;


    /////////////////////////////////////////////////////


    public NoticeDO(Long noticeId, ENoticeType noticeType, int priority, String title, String message, String image, String url) {
        this.noticeId = noticeId;
        this.noticeType = noticeType;
        this.priority = priority;
        this.title = title;
        this.message = message;
        this.image = image;
        this.url = url;
    }

    public NoticeDO() {

    }

    public int getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(int deviceType) {
        this.deviceType = deviceType;
    }

    public Long getNoticeId() {
        return noticeId;
    }

    public void setNoticeId(Long noticeId) {
        this.noticeId = noticeId;
    }

    public List<Integer> getUserGroupIds() {
        return userGroupIds;
    }

    public void setUserGroupIds(List<Integer> userGroupIds) {
        this.userGroupIds = userGroupIds;
    }

    public ENoticeType getNoticeType() {
        return noticeType;
    }

    public void setNoticeType(ENoticeType noticeType) {
        this.noticeType = noticeType;
    }

    public void setNoticeTypeStr(String noticeType) {
        this.noticeType = ENoticeType.valueOf(noticeType);
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ENoticeFrequency getFrequency() {
        return frequency;
    }

    public void setFrequency(ENoticeFrequency frequency) {
        this.frequency = frequency;
    }

    public void setFrequencyStr(String frequency) {
        this.frequency = ENoticeFrequency.valueOf(frequency);
    }

    public int getPriority() {
        return priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ENoticeStatus getStatus() {
        return status;
    }

    public void setStatus(ENoticeStatus status) {
        this.status = status;
    }

    public void setStatusStr(String status) {
        this.status = ENoticeStatus.valueOf(status);
    }

    public Long getStartTime() {
        return startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public String getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getImageChecksum() {
        return imageChecksum;
    }

    public void setImageChecksum(String imageChecksum) {
        this.imageChecksum = imageChecksum;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public Date getStartTime2() {
        return startTime2;
    }

    public void setStartTime2(Date startTime2) {
        this.startTime2 = startTime2;
    }

    public Date getEndTime2() {
        return endTime2;
    }

    public void setEndTime2(Date endTime2) {
        this.endTime2 = endTime2;
    }

    public int getUserType() {
        return userType;
    }

    public void setUserType(int userType) {
        this.userType = userType;
    }

    public int getLoginType() {
        return loginType;
    }

    public void setLoginType(int loginType) {
        this.loginType = loginType;
    }

    public int getServiceStatus() {
        return serviceStatus;
    }

    public void setServiceStatus(int serviceStatus) {
        this.serviceStatus = serviceStatus;
    }

    public String getProductModel() {
        return productModel;
    }

    public void setProductModel(String productModel) {
        this.productModel = productModel;
    }

    public EPotalNoticeType getPotalNoticeType() {
        return potalNoticeType;
    }

    public void setPotalNoticeType(EPotalNoticeType potalNoticeType) {
        this.potalNoticeType = potalNoticeType;
    }

    public String getMobileMaxVersion() {
        return mobileMaxVersion;
    }

    public void setMobileMaxVersion(String mobileMaxVersion) {
        this.mobileMaxVersion = mobileMaxVersion;
    }

    public String getMobileMinVersion() {
        return mobileMinVersion;
    }

    public void setMobileMinVersion(String mobileMinVersion) {
        this.mobileMinVersion = mobileMinVersion;
    }

    public String getStbMaxVersion() {
        return stbMaxVersion;
    }

    public void setStbMaxVersion(String stbMaxVersion) {
        this.stbMaxVersion = stbMaxVersion;
    }

    public String getStbMinVersion() {
        return stbMinVersion;
    }

    public void setStbMinVersion(String stbMinVersion) {
        this.stbMinVersion = stbMinVersion;
    }

    public String getShowType() {
        return showType;
    }

    public void setShowType(String showType) {
        this.showType = showType;
    }

    public int getListId() {
        return listId;
    }

    public void setListId(int listId) {
        this.listId = listId;
    }

    public String getTtId() {
        return ttId;
    }

    public void setTtId(String ttId) {
        this.ttId = ttId;
    }

    public String getNoticeSize() {
        return noticeSize;
    }

    public void setNoticeSize(String noticeSize) {
        this.noticeSize = noticeSize;
    }

    public String getViewImg() {
        return viewImg;
    }

    public void setViewImg(String viewImg) {
        this.viewImg = viewImg;
    }

    public int getLinkType() {
        return linkType;
    }

    public void setLinkType(int linkType) {
        this.linkType = linkType;
    }

    public Integer getBannerToken() {
        return bannerToken;
    }

    public void setBannerToken(Integer bannerToken) {
        this.bannerToken = bannerToken;
    }
}
