/*
 * Created by Gabriel Souza on 03/09/18 18:14
 * Copyright Valoroso Ltd. (c) 2018.  All rights reserved.
 */

package com.valor.vod.api.model.user;

public enum EActionType {
    QUERY(0, "query"),
    REGISTER(1, "register"),
    ACTIVATE(2, "activate"),
    LOGIN(3, "login"),
    RECHARGE(4, "recharge"),
    RECHARGE_BY_AGENT(5, "recharge_by_agent"),
    REFUND(6, "refund"),
    BIND_EMAIL(7, "bind_email"),
    BIND_MOBILE(8, "bind_mobile");

    int code;
    String codeInfo = "";

    EActionType(int code, String codeInfo) {
        this.code = code;
        this.codeInfo = codeInfo;
    }

    public static EActionType getByCode(int code) {
        EActionType[] loginTypes = EActionType.values();
        for (int i = 0; i < loginTypes.length; i++) {
            if (loginTypes[i].getCode() == code) {
                return loginTypes[i];
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getCodeInfo() {
        return codeInfo;
    }

    public void setCodeInfo(String codeInfo) {
        this.codeInfo = codeInfo;
    }

}
