package com.valor.vod.api.model.user;

import java.util.Objects;

/**
 * @author Tom
 * @since 2022-09-13
 */
public enum EChannelType {
    /** 邮箱 */
    CHANNEL_EMAIL(0),
    /** 验证码 */
    CHANNEL_SMS(1),
    ;

    private final int code;

    EChannelType(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    public static EChannelType of(Integer code) {
        for (EChannelType e : EChannelType.values()) {
            if (Objects.equals(e.getCode(), code)) {
                return e;
            }
        }
        return null;
    }
}
