/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.api.model.user;

import com.valor.vod.api.model.user.EAccountLoginType;
import com.valor.vod.api.model.user.ELoginIdType;
import com.valor.vod.api.model.user.EUserType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class LoginIdTypeConverter {
    private static final Map<Integer, ELoginIdType> USER_TYPE_TO_LOGIN_ID_TYPE_MAP = new HashMap<Integer, ELoginIdType>(){
        {
            this.put(EUserType.MAC.getCode(), ELoginIdType.DEVICE);
            this.put(EUserType.ACCOUNT_CARD.getCode(), ELoginIdType.ACCOUNT_CARD);
            this.put(EUserType.EMAIL.getCode(), ELoginIdType.EMAIL);
            this.put(EUserType.EMAIL_BINDING.getCode(), ELoginIdType.EMAIL);
            this.put(EUserType.MOBILE.getCode(), ELoginIdType.MOBILE);
            this.put(EUserType.MOBILE_BINDING.getCode(), ELoginIdType.MOBILE);
            this.put(EUserType.THIRD_PARTY.getCode(), ELoginIdType.THIRD_PARTY);
        }
    };
    private static final Map<Integer, ELoginIdType> ACCOUNT_LOGIN_TYPE_TO_LOGIN_ID_TYPE_MAP = new HashMap<Integer, ELoginIdType>(){
        {
            this.put(EAccountLoginType.DEVICE.getCode(), ELoginIdType.DEVICE);
            this.put(EAccountLoginType.ACCOUNT_CARD.getCode(), ELoginIdType.ACCOUNT_CARD);
            this.put(EAccountLoginType.EMAIL.getCode(), ELoginIdType.EMAIL);
            this.put(EAccountLoginType.AC_BINDING_EMAIL.getCode(), ELoginIdType.EMAIL);
            this.put(EAccountLoginType.MOBILE.getCode(), ELoginIdType.MOBILE);
            this.put(EAccountLoginType.AC_BINDING_MOBILE.getCode(), ELoginIdType.MOBILE);
            this.put(EAccountLoginType.THIRD_PARTY.getCode(), ELoginIdType.THIRD_PARTY);
        }
    };
    private static final Map<String, EAccountLoginType> LOGIN_ID_TYPE_NAME_TO_ACCOUNT_LOGIN_TYPE_MAP = new HashMap<String, EAccountLoginType>(){
        {
            this.put(ELoginIdType.DEVICE.name(), EAccountLoginType.DEVICE);
            this.put(ELoginIdType.ACCOUNT_CARD.name(), EAccountLoginType.ACCOUNT_CARD);
            this.put(ELoginIdType.EMAIL.name(), EAccountLoginType.EMAIL);
            this.put(ELoginIdType.MOBILE.name(), EAccountLoginType.MOBILE);
            this.put(ELoginIdType.THIRD_PARTY.name(), EAccountLoginType.THIRD_PARTY);
        }
    };

    public static Optional<ELoginIdType> ofUserType(Integer userType) {
        return Optional.ofNullable(USER_TYPE_TO_LOGIN_ID_TYPE_MAP.get(userType));
    }

    public static Optional<ELoginIdType> ofAccountLoginType(int accountLoginType) {
        return Optional.ofNullable(ACCOUNT_LOGIN_TYPE_TO_LOGIN_ID_TYPE_MAP.get(accountLoginType));
    }

    public static String ofUserTypeToName(Integer userType) {
        return LoginIdTypeConverter.ofUserType(userType).map(Enum::name).orElse(null);
    }

    public static String ofAccountLoginTypeToName(Integer accountLoginType) {
        return LoginIdTypeConverter.ofAccountLoginType(accountLoginType).map(Enum::name).orElse(null);
    }

    public static Optional<EAccountLoginType> toAccountLoginType(String loginIdType) {
        return Optional.ofNullable(LOGIN_ID_TYPE_NAME_TO_ACCOUNT_LOGIN_TYPE_MAP.get(loginIdType));
    }

    public static Integer toAccountLoginTypeCode(String loginIdType) {
        return LoginIdTypeConverter.toAccountLoginType(loginIdType).map(EAccountLoginType::getCode).orElse(null);
    }
}

