package com.valor.vod.api.model.constant;

/**
 * EArtworkType
 *
 * @author Frank
 * @since 2015/10/30 0:00
 */
public enum EArtworkType {
    /** 未知 */
    UNKNOWN,
    /** 海报 */
    POSTER,
    /** 横幅 */
    BANNER,
    /** 手绘(含义不清) */
    FANART,
    /** 视频截图 */
    VIDEOIMAGE,
    /** 背景图 */
    BACKDROP,
    /** 照片 */
    PHOTO,
    ;

    public static EArtworkType fromString(String type) {
        try {
            return EArtworkType.valueOf(type.trim().toUpperCase());
        } catch (IllegalArgumentException ex) {
            return UNKNOWN;
        }
    }
}
