package com.valor.vod.api.model.constant;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * EPlaylistShowType
 *
 * @author Frank
 * @since 2016/1/8 11:24
 */
public enum EPlaylistShowType {
    /** 普通 */
    NORMAL,
    /** 专题 */
    SPECIAL_TOPIC,
    /** 过滤 */
    FILTER,
    /** 推荐 */
    RECOMMEND;

    private static final Map<String, EPlaylistShowType> VALUE_MAP =
            Stream.of(values())
                    .collect(Collectors.toMap(EPlaylistShowType::name, Function.identity()));

    public static EPlaylistShowType of(String value) {
        if (value == null) {
            return null;
        }

        return VALUE_MAP.get(value);
    }
}
