package com.valor.vod.api.model.constant;

/**
 * playlist status
 *
 * @author Frank
 */
public enum EPlaylistStatus {
    /** Disable */
    DISABLE,
    /** normal,can show in page */
    NORMAL,
    ;

    public static EPlaylistStatus fromString(String type) {
        try {
            return EPlaylistStatus.valueOf(type.trim().toUpperCase());
        } catch (IllegalArgumentException ex) {
            return DISABLE;
        }
    }

    public static EPlaylistStatus valueOf(int type) {
        switch (type) {
            case 1:
                return NORMAL;
            default:
                return DISABLE;
        }
    }
}
