package com.valor.vod.api.model.constant;

/**
 * MetaType
 *
 * @author Bruce Wu
 * @since 2023-03-14
 */
public enum EVideoType {
    /** UNKNOWN:0 */
    UNKNOWN,
    /** PLAYLIST类型:1 */
    PLAYLIST,
    /** 搜索列表:2 */
    SEARCH_LIST,
    /** This is a movie:3 */
    MOVIE,
    /** This is a TV Series:4 */
    SERIES,
    /** This is a season of a TV series:5 */
    SEASON,
    /** This is an episode of a TV season:6 */
    EPISODE,
    /** 记录片:7 */
    DOCUMENTARY,
    /** 短片:8 */
    SHORT,
    /** 视频:9 */
    VIDEO,
    /** TV 特别节目:10 */
    TV_SPECIAL,
    /** 人物:11 */
    PERSON,
    /** 成人:12 */
    ADULT,
    /** 结束标识 */
    VIDOE_TYPE_END;

    public static EVideoType valueOf(int videoTypeInt) {
        switch (videoTypeInt) {
            case 1:
                return PLAYLIST;
            case 2:
                return SEARCH_LIST;
            case 3:
                return MOVIE;
            case 4:
                return SERIES;
            case 5:
                return SEASON;
            case 6:
                return EPISODE;
            case 7:
                return DOCUMENTARY;
            case 8:
                return SHORT;
            case 9:
                return VIDEO;
            case 10:
                return TV_SPECIAL;
            default:
                return UNKNOWN;
        }
    }
}
