package com.valor.vod.api.model.constant.response;

/**
 * EFilmographyJob
 *
 * @author Frank.Huang
 * @since 2016/12/14
 */
public enum EFilmographyJob {
    /** 未知 */
    UNKNOWN,
    /** 导演 */
    DIRECTOR,
    /** 演员 */
    ACTOR,
    /** 配音 */
    SOUNDTRACK,
    /** 自己,谈话和访谈节目 */
    SELF,
    /** 编剧 */
    WRITER,
    /** 制片人 */
    PRODUCER,
    ;

    public static final String IMDB_LABEL_ACTOR = "ACTOR";
    public static final String IMDB_LABEL_ACTRESS = "ACTRESS";
    public static final String IMDB_LABEL_DIRECTOR = "DIRECTOR";
    public static final String IMDB_LABEL_SELF = "SELF";
    public static final String IMDB_LABEL_WRITER = "WRITER";
    public static final String IMDB_LABEL_SOUNDTRACK = "SOUNDTRACK";
    public static final String IMDB_LABEL_PRODUCER = "PRODUCER";

    public static EFilmographyJob valueOfString(String v) {
        if (v == null || v.isEmpty()) {
            return UNKNOWN;
        }

        switch (v.toUpperCase()) {
            case IMDB_LABEL_ACTOR:
            case IMDB_LABEL_ACTRESS:
                return ACTOR;
            case IMDB_LABEL_DIRECTOR:
                return DIRECTOR;
            case IMDB_LABEL_SELF:
                return SELF;
            case IMDB_LABEL_SOUNDTRACK:
                return SOUNDTRACK;
            case IMDB_LABEL_WRITER:
                return WRITER;
            case IMDB_LABEL_PRODUCER:
                return PRODUCER;
            default:
                return UNKNOWN;
        }
    }
}
