package com.valor.vod.api.model.meta.banner.v1;

import com.valor.vod.api.model.common.AbstractPrintable;
import lombok.Getter;
import lombok.Setter;

/**
 * Created by charlie on 2019/8/30.
 */
@Getter
@Setter
public class BannerDO extends AbstractPrintable {
    /**
     * 消息id
     */
    private Long bannerId;
    /**
     * 1 节目 2 列表 3 链接 4 网盘 5 会员网站
     */
    private Integer type;
    /**
     * 轮播图url
     */
    private String imageUrl;
    /**
     * 当bannerType=1时，type值为如下值时
     *   当type=1时 meta_id(tt号),
     *   当type=2时 playlist_id,
     *   当type=3时 跳转的url
     *   当type=4时 add cloud/import from internet/cloud
     *   当type=5时 会员网站只有图片，此值为空值
     * 当bannerType=2时，type没有值返回
     *   此时data数据为视频的url
     */
    private String data;
    /**
     * 横幅类型
     * 1、img
     * 2、video
     */
    private Integer bannerType;
    /**
     * 展示类型，一般是0
     */
    private Integer showType;
}
