package com.valor.vod.api.model.meta.media.v1;

/**
 * @author Frank
 * @date 2015/10/25 14:26
 */
public enum TrailerType {
    /** 未知 */
    UNKNOWN,
    /** 预告片 */
    TRAILER,
    /** 剪辑 */
    CLIPS,
    /** 短故事片 */
    FEATURETTE,
    /** 预映 */
    PREVIEW,
    ;

    public static TrailerType fromString(String type) {
        try {
            return TrailerType.valueOf(type.trim().toUpperCase());
        } catch (IllegalArgumentException ex) {
            return UNKNOWN;
        }
    }
}
