package com.valor.vod.api.model.meta.media.v1;

import com.valor.vod.api.model.meta.base.v1.BaseMetaDO;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * VideoMetaDO
 *
 * @author Frank
 * @date 2016/1/13 21:27
 */
public class VideoMetaDO extends BaseMetaDO {

    /** 第一语言 */
    protected String language;
    /** 概述 */
    protected String outline;
    /** 标语 */
    protected String tagline;
    /** tmdb id */
    protected String tmdbId;
    /** imdb id */
    protected String imdbId;
    /** 首次释出日期 */
    protected String firstReleaseDate = "";
    /** 首次释出国家简称 */
    protected String firstReleaseCountryShort = "";
    /** 首次释出国家 */
    protected String firstReleaseCountry = "";
    /** 释出国家简称 */
    protected String releaseCountryShort = "";
    /** 释出国家 */
    protected String releaseCountry = "";
    /** 原始标题 */
    protected String originalTitle = "";
    /** 发行年份 */
    protected int publicationYear;
    /** 连续剧ID */
    protected long seriesId = -1;
    /** 季ID */
    protected long seasonId = -1;
    /** 第几季 */
    protected int season = -1;
    /** 第几集 */
    protected int episode = -1;
    /** 职员表 */
    protected CastDO casts;
    /** 预告片 */
    protected List<TrailerDO> trailers = new ArrayList<>();
    /** 艺术照 */
    protected List<ArtworkDO> artworks = new ArrayList<>();
    /** 国家列表 */
    protected List<CountryDO> countries = new ArrayList<>();
    /** 别名 */
    protected Map<String, TitleAKADo> akas = new HashMap<>();
    /** 媒体标签 */
    protected List<MediaTagDO> mediaTags = new ArrayList<>();
    /** 上传用户 */
    protected String uploader = "";

    public int getPublicationYear() {
        return publicationYear;
    }

    public void setPublicationYear(int publicationYear) {
        this.publicationYear = publicationYear;
    }

    public String getUploader() {
        return uploader;
    }

    public void setUploader(String uploader) {
        this.uploader = uploader;
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getOutline() {
        return outline;
    }

    public void setOutline(String outline) {
        this.outline = outline;
    }

    public String getTagline() {
        return tagline;
    }

    public void setTagline(String tagline) {
        this.tagline = tagline;
    }

    public String getTmdbId() {
        return tmdbId;
    }

    public void setTmdbId(String tmdbId) {
        this.tmdbId = tmdbId;
    }

    public String getImdbId() {
        return imdbId;
    }

    public void setImdbId(String imdbId) {
        this.imdbId = imdbId;
    }

    public CastDO getCasts() {
        return casts;
    }

    public void setCasts(CastDO casts) {
        this.casts = casts;
    }

    public List<TrailerDO> getTrailers() {
        return trailers;
    }

    public void setTrailers(List<TrailerDO> trailers) {
        this.trailers = trailers;
    }

    public List<ArtworkDO> getArtworks() {
        return artworks;
    }

    public void setArtworks(List<ArtworkDO> artworks) {
        this.artworks = artworks;
    }

    public List<CountryDO> getCountries() {
        return countries;
    }

    public void setCountries(List<CountryDO> countries) {
        this.countries = countries;
    }

    public long getSeriesId() {
        return seriesId;
    }

    public void setSeriesId(long seriesId) {
        this.seriesId = seriesId;
    }

    public long getSeasonId() {
        return seasonId;
    }

    public void setSeasonId(long seasonId) {
        this.seasonId = seasonId;
    }

    public int getSeason() {
        return season;
    }

    public void setSeason(int season) {
        this.season = season;
    }

    public int getEpisode() {
        return episode;
    }

    public void setEpisode(int episode) {
        this.episode = episode;
    }

    public String getFirstReleaseDate() {
        return firstReleaseDate;
    }

    public void setFirstReleaseDate(String firstReleaseDate) {
        this.firstReleaseDate = firstReleaseDate;
    }

    public String getFirstReleaseCountryShort() {
        return firstReleaseCountryShort;
    }

    public void setFirstReleaseCountryShort(String firstReleaseCountryShort) {
        this.firstReleaseCountryShort = firstReleaseCountryShort;
    }

    public String getFirstReleaseCountry() {
        return firstReleaseCountry;
    }

    public void setFirstReleaseCountry(String firstReleaseCountry) {
        this.firstReleaseCountry = firstReleaseCountry;
    }

    public String getReleaseCountryShort() {
        return releaseCountryShort;
    }

    public void setReleaseCountryShort(String releaseCountryShort) {
        this.releaseCountryShort = releaseCountryShort;
    }

    public String getReleaseCountry() {
        return releaseCountry;
    }

    public void setReleaseCountry(String releaseCountry) {
        this.releaseCountry = releaseCountry;
    }

    public String getOriginalTitle() {
        return originalTitle;
    }

    public void setOriginalTitle(String originalTitle) {
        this.originalTitle = originalTitle;
    }

    public Map<String, TitleAKADo> getAkas() {
        return akas;
    }

    public void setAkas(Map<String, TitleAKADo> akas) {
        this.akas = akas;
    }

    public List<MediaTagDO> getMediaTags() {
        return mediaTags;
    }

    public void setMediaTags(List<MediaTagDO> mediaTags) {
        this.mediaTags = mediaTags;
    }
}
