package com.valor.vod.api.model.meta.playlist.v1;

import com.valor.vod.api.model.constant.EPlaylistShowType;
import com.valor.vod.api.model.constant.EPlaylistType;
import com.valor.vod.api.model.meta.base.v1.BaseMetaDO;

/**
 * @author Frank
 * @date 2016/1/8 11:09
 */
public class PlaylistMetaDO extends BaseMetaDO {

    /** 播放列表ID */
    private Long playlistId;
    /** 名称 */
    protected String name = "";
    /** 播放列表描述 */
    protected String description = "";
    /** 显示样式 */
    protected EPlaylistShowType showType = EPlaylistShowType.NORMAL;
    /** 筛选目标 */
    protected String target = "";
    /** 展示顺序 */
    protected int showSeq = 0;
    /** vip */
    protected int isVip = 0;
    /** 是否可过滤 */
    protected int canFilter = 0;
    /** 列表是否开放 */
    protected boolean open;
    /** 用户是否选择genre或者tag */
    protected boolean selectedGenreOrTag = false;
    /** node_display uiKey */
    private String uiKey;

    public void setPlaylistId(Long playlistId) {
        this.playlistId = playlistId;
    }

    public Long getPlaylistId() {
        return playlistId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public EPlaylistShowType getShowType() {
        return showType;
    }

    public void setShowType(EPlaylistShowType showType) {
        this.showType = showType;
    }

    public String getTarget() {
        return target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public int getShowSeq() {
        return showSeq;
    }

    public void setShowSeq(int showSeq) {
        this.showSeq = showSeq;
    }

    public int getIsVip() {
        return isVip;
    }

    public void setIsVip(int isVip) {
        this.isVip = isVip;
    }

    public void setTypeStr(String type) {
        this.setListType(EPlaylistType.valueOf(type));
    }

    public int getCanFilter() {
        return canFilter;
    }

    public void setCanFilter(int canFilter) {
        this.canFilter = canFilter;
    }

    public boolean isOpen() {
        return open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public boolean isSelectedGenreOrTag() {
        return selectedGenreOrTag;
    }

    public void setSelectedGenreOrTag(boolean selectedGenreOrTag) {
        this.selectedGenreOrTag = selectedGenreOrTag;
    }

    public void setUiKey(String uiKey) {
        this.uiKey = uiKey;
    }

    public String getUiKey() {
        return uiKey;
    }
}
