package com.valor.vod.api.model.notice;

import com.valor.vod.api.model.common.AbstractPrintable;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;
import java.util.List;

/**
 * File        : valormotorserver:${FILENAME}
 * Description :
 * Author      : Frank
 * Created     : 2015/9/4
 */
@Getter
@Setter
public class NoticeDO extends AbstractPrintable {
    /**
     * 消息id
     */
    private Long noticeId;
    /**
     * 区域
     */
    private String region = "defailt";
    /**
     * 语言
     */
    private String language;
    /**
     * 类型
     */
    private ENoticeType noticeType;
    /**
     * 展示频率  ONCE/ALWAYS
     */
    private ENoticeFrequency frequency = ENoticeFrequency.ALWAYS;
    /**
     * 优先级
     */
    private int priority;
    /**
     * 标题
     */
    private String title;
    /**
     * 消息内容
     */
    private String message;
    /**
     * 图片
     */
    private String image;
    /**
     * url
     */
    private String url;
    /**
     * 开始时间(格式:yyyymmdd)
     */
    private Long startTime;
    /**
     * 结束时间(格式:yyyymmdd)
     */
    private Long endTime;
    /**
     * 固定值:NORMAL
     */
    private ENoticeStatus status;
    /**
     * 更新时间
     */
    private String updateTime;
    private String imageChecksum;
    private Date startTime2;
    private Date endTime2;
    private int userType;
    private int loginType;
    /**
     * 设备类型
     */
    private int deviceType;
    private int serviceStatus;
    private String productModel;
    private List<Integer> userGroupIds;
    /**
     * vod_message.msg_type
     */
    private EPotalNoticeType potalNoticeType;
    /**
     * 手机最高版本
     */
    private String mobileMaxVersion;
    /**
     * 手机最低版本
     */
    private String mobileMinVersion;
    /**
     * 盒子最高版本
     */
    private String stbMaxVersion;
    /**
     * 盒子最低版本
     */
    private String stbMinVersion;
    /**
     * vod_message_content.bannerType
     */
    private String bannerType;
    /**
     * vod_message_content.showType
     */
    private String showType;
    /**
     * vod_message_content.list_id
     */
    private int listId;
    /**
     * vod_message_content.tt_id
     */
    private String ttId;
    /**
     * vod_message_content.notice_size
     */
    private String noticeSize;
    /**
     * vod_message_content.viewImg
     */
    private String viewImg;
    /**
     * vod_message_content.banner_token
     * 用以区分不同列表展示
     */
    private Integer bannerToken;
    /**
     * vod_message_content.showType
     */
    private int linkType;

    private Long vmsId;

    public NoticeDO(Long noticeId, ENoticeType noticeType, int priority, String title, String message, String image, String url) {
        this.noticeId = noticeId;
        this.noticeType = noticeType;
        this.priority = priority;
        this.title = title;
        this.message = message;
        this.image = image;
        this.url = url;
    }

    public NoticeDO() {
    }
}
