package com.valor.vod.api.model.user;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 设备信息Dto
 *
 * @author Tom Tang
 * @date 2023/3/17
 */
@Getter
@Setter
@Accessors(chain = true)
@NoArgsConstructor(staticName = "create")
public class DeviceDto {

    /**
     * 设备ID
     *
     * @mock ec2cbb923bea
     */
    private String did;

    /**
     * android id
     *
     * @mock bcbc00f09479aa5b
     */
    private String androidId;

    /**
     * CPU序列号
     *
     * @mock 2b0b0100011912000017323830523050
     */
    private String cpuSerial;

    /**
     * imei id
     *
     * @mock 865872025238821
     */
    private String imei;

    /**
     * model
     *
     * @mock B11
     */
    private String model;

    /**
     * 以太网mac
     */
    private String ethernetMac;

    /**
     * 蓝牙mac
     */
    private String bluetoothMac;

    /**
     * wifi mac。
     */
    private String wifiMac;

    /**
     * firmware
     */
    private String firmware;

    /**
     * brand
     */
    private String brand;

    /**
     * manufacturer
     */
    private String manufacturer;

    /**
     * sdk
     */
    private String sdk;

    /**
     * system version
     */
    private String systemVersion;

    /**
     * display
     */
    private String display;

    /**
     * host
     */
    private String host;

    /**
     * user
     */
    private String user;

    /**
     * device
     */
    private String device;


    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
