package com.valor.vod.api.model.user;

/** File : Description : Author : Frank Created : 2015/10/4 23:58 */
public enum EAccountProperty {
    LOGGED_IN_BY_APP(BIT_MASK(0)), // APP has logged in
    TRIALLED(BIT_MASK(1)), // Used trial period
    TRIAL_USER(BIT_MASK(2)), // Trial period user
    EMAIL_UNVERIFIED(BIT_MASK(3)), // Email need verification
    CLOUD_CONTENT_MISSING(BIT_MASK(4)), // Cloud content needed
    IS_RENEWING(BIT_MASK(5)), // have a renewing plan
    FREE_TO_CHARGE(BIT_MASK(6)), // free trial to membership
    EMAIL_BINDING_PROFILE_DATA_MIGRATION(BIT_MASK(7)), // 邮箱绑定Profile 数据迁移
    EMAIL_BINDING_BIZ_DATE_UPDATE(BIT_MASK(8)), // 邮箱绑定有效期转移
    EMAIL_BINDING_CLOUD_DATA_MIGRATION(BIT_MASK(9)), // 邮箱绑定网盘数据转移
    EMAIL_UNSUBSCRIBE(BIT_MASK(10)), // 邮件退订
    PAID_ONLINE(BIT_MASK(11)), // 已经购买了线上套餐
    ALREADY_TRANSFER_PRE_INSTALL_BIZ(BIT_MASK(12)), // 已经转移了预装设备的有效期
    USE_RECHARGE(BIT_MASK(13)), // 已经使用了充值码
    IS_DEVICE_LOGIN(BIT_MASK(14)), // Mac登录方式10000000000000
    PLAY_ALLOWED(BIT_MASK(15)), // 播放基本服务(0)
    TEST(BIT_MASK(16)), // 测试用户
    STANDALONE(BIT_MASK(17)), // 独立部署APP
    LOCATION_UNLIMITED(BIT_MASK(18)), // 不限制位置信息
    LOCATION_ILLEGAL(BIT_MASK(19)), // 非法的登录位置
    CONTENTS_AUTO_ADD(BIT_MASK(20)), // 自动添加网盘
    CONTENTS_ADDED(BIT_MASK(21)), // 已经自动添加过网盘
    FREE_TO_MEMBERSHIP(BIT_MASK(22)), // 该设备绑定的账号从free trial套餐转变为membership套餐
    MIGRATED_DATA(BIT_MASK(23)), // 该设备是否已经迁移过数据
    ALREADY_SHOW_BINDING_TIPS(BIT_MASK(24)), // 已经展示过绑定提示
    ALREADY_BIND_EMAIL(BIT_MASK(25)), // 已经绑定email
    ALREADY_BIND_MOBILE(BIT_MASK(26)), // 已经绑定mobile
    ALREADY_BIND_CARD(BIT_MASK(27)), // 已经绑定账号卡
    ALREADY_BIND_ACTIVE(BIT_MASK(28)), // 绑定邮箱或手机已激活
    ;

    private long value;

    EAccountProperty(long value) {
        this.value = value;
    }

    private static long BIT_MASK(int bit) {
        return 1L << bit;
    }

    public long getValue() {
        return value;
    }
}
