package com.valor.vod.api.model.user;
/**
 * 套餐类型
 *
 * @author Tom
 * @since 2021-07-06
 */
public enum EPlanType {
    /** 预装套餐 */
    PRE_INSTALL(1, "PRE_INSTALL"),
    /** EMAIL账号套餐 */
    EMAIL(2, "EMAIL"),
    /** 账号卡套餐 */
    ACCOUNT_CARD(3, "ACCOUNT_CARD"),
    /** 充值卡套餐 */
    RECHARGE_CARD(4, "RECHARGE_CARD"),
    /** 支付系统套餐 */
    BILL_PRODUCT(5, "BILL_PRODUCT"),
    /** 手机账号套餐 */
    MOBILE(6, "MOBILE"),
    /** 邮箱账号绑定套餐 */
    ACCOUNT_BINDING_EMAIL(7, "ACCOUNT_BINDING_EMAIL"),
    /** 手机账号绑定套餐 */
    ACCOUNT_BINDING_MOBILE(8, "ACCOUNT_BINDING_MOBILE"),
    /** 第三方套餐 */
    THIRD_PARTY_PAID(9, "ACCOUNT_THIRD_PARTY"),
    ;

    private final int value;
    private final String text;

    EPlanType(int value, String text) {
        this.value = value;
        this.text = text;
    }

    public int getValue() {
        return value;
    }

    public String getText() {
        return text;
    }
}
