/*
 *      Copyright (c) 2004-2015 YAMJ Members
 *      https://github.com/organizations/YAMJ/teams
 *
 *      This file is part of the Yet Another Media Jukebox (YAMJ).
 *
 *      YAMJ is free software: you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, either version 3 of the License, or
 *      any later version.
 *
 *      YAMJ is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with YAMJ.  If not, see <http://www.gnu.org/licenses/>.
 *
 *      Web: https://github.com/YAMJ/yamj-v3
 *
 */
package com.valor.vod.api.model.common.response;

/**
 * @author Stuart
 */
public class ResponseStatus extends ResponseSign {
    protected String host = "";
    protected long serverTimeMS = System.currentTimeMillis();
    protected int retCode = 0;     //返回码
    protected int errCode = 0;     //错误码
    protected String message = "ok";  //错误消息

    public ResponseStatus() {
    }

    public ResponseStatus(int retCode, int errCode, String message) {
        setStatus(retCode, errCode, message);
    }


    public int getRetCode() {
        return retCode;
    }

    public void setRetCode(int retCode) {
        this.retCode = retCode;
    }

    public int getErrCode() {
        return errCode;
    }

    public void setErrCode(int errCode) {
        this.errCode = errCode;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setStatus(int retCode, int errCode, String message) {
        this.retCode = retCode;
        this.errCode = errCode;
        this.message = message;
    }

    public long getServerTimeMS() {
        return serverTimeMS;
    }

    public void setServerTimeMS(long serverTimeMS) {
        this.serverTimeMS = serverTimeMS;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }


    public boolean isSuccess() {
        return (retCode == 0 && errCode == 0);
    }
}
