/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.api.model.constant;

public enum JobType {
    UNKNOWN,
    DIRECTOR,
    ACTOR,
    GUEST_STAR,
    WRITER,
    PRODUCER,
    CAMERA,
    EDITING,
    ART,
    COSTUME_MAKEUP,
    SOUND,
    EFFECTS,
    CREW,
    LIGHTING,
    CREATOR;


    public static JobType fromString(String type) {
        try {
            return JobType.valueOf(type.trim().toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            return UNKNOWN;
        }
    }

    public static JobType valueOf(int jobType) {
        switch (jobType) {
            case 1: {
                return DIRECTOR;
            }
            case 2: {
                return ACTOR;
            }
            case 3: {
                return GUEST_STAR;
            }
            case 4: {
                return WRITER;
            }
            case 5: {
                return PRODUCER;
            }
            case 6: {
                return CAMERA;
            }
            case 7: {
                return EDITING;
            }
            case 8: {
                return ART;
            }
            case 9: {
                return COSTUME_MAKEUP;
            }
            case 10: {
                return SOUND;
            }
            case 11: {
                return EFFECTS;
            }
            case 12: {
                return CREW;
            }
            case 13: {
                return LIGHTING;
            }
        }
        return UNKNOWN;
    }
}

