package com.valor.vod.cloud.blackGrey;

import com.valor.vod.cloud.model.database.dao.CloudBaseDao;
import com.valor.vod.cloud.model.database.ddo.CloudPkgBgDdo;
import common.base.tools.type.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author clovis
 * @date 2022/11/11
 */
@Repository
@Transactional(value = "cloudTransactionManager")
public class CloudPkgBgDao extends CloudBaseDao {
    @Autowired
    protected SessionFactory cloudSessionFactory;

    @Override
    @Transactional("cloudTransactionManager")
    public Session currentSession() {
        return this.cloudSessionFactory.getCurrentSession();
    }

    /**
     * 查询网盘包数量
     */
    public long count(String pkgId, Integer type) {
        Criteria criteria = currentSession().createCriteria(CloudPkgBgDdo.class);
        if (StringUtils.isNotBlank(pkgId)) {
            criteria.add(Restrictions.eq("pkgId", Long.parseLong(pkgId)));
        }
        if (type != null) {
            criteria.add(Restrictions.eq("type", type));
        }
        criteria.setProjection(Projections.rowCount());
        return (long) criteria.uniqueResult();
    }

    /**
     * 查询网盘包列表
     */
    @Transactional("cloudTransactionManager")
    public List<CloudPkgBgDdo> list(String pkgId, Integer type, int start, int size) {
        Criteria criteria = currentSession().createCriteria(CloudPkgBgDdo.class);
        if (StringUtils.isNotBlank(pkgId)) {
            criteria.add(Restrictions.eq("pkgId", Long.parseLong(pkgId)));
        }
        if (type != null) {
            criteria.add(Restrictions.eq("type", type));
        }
        criteria.setFirstResult(start);
        criteria.setMaxResults(size);
        List<CloudPkgBgDdo> results = criteria.list();
        if (CollectionUtils.isNullOrEmpty(results)) {
            return new ArrayList<>();
        }
        return results;
    }

    /**
     * 查询网盘包
     */
    @Transactional("cloudTransactionManager")
    public List<CloudPkgBgDdo> queryList(List<Long> pkgIds) {
        Criteria criteria = currentSession().createCriteria(CloudPkgBgDdo.class);
        criteria.add(Restrictions.in("pkgId", pkgIds));
        List<CloudPkgBgDdo> results = criteria.list();
        if (CollectionUtils.isNullOrEmpty(results)) {
            return new ArrayList<>();
        }
        return results;
    }

    /**
     * 查询网盘包黑名单
     */
    public List<Long> queryBlackList(Set<Long> pkgIds) {
        if (CollectionUtils.isNullOrEmpty(pkgIds)) {
            return new ArrayList<>();
        }
        Criteria criteria = currentSession().createCriteria(CloudPkgBgDdo.class);
        criteria.add(Restrictions.in("pkgId", pkgIds));
        criteria.add(Restrictions.eq("type", 0));
        criteria.add(Restrictions.eq("status", 0));
        List<CloudPkgBgDdo> results = criteria.list();
        if (CollectionUtils.isNullOrEmpty(results)) {
            return new ArrayList<>();
        }
        return results.stream().map(CloudPkgBgDdo::getPkgId).collect(Collectors.toList());
    }

    /**
     * 查询网盘包黑灰名单
     */
    public List<CloudPkgBgDdo> queryValidList(List<Long> pkgIds) {
        if (CollectionUtils.isNullOrEmpty(pkgIds)) {
            return new ArrayList<>();
        }
        Criteria criteria = currentSession().createCriteria(CloudPkgBgDdo.class);
        criteria.add(Restrictions.in("pkgId", pkgIds));
        criteria.add(Restrictions.eq("status", 0));
        List<CloudPkgBgDdo> results = criteria.list();
        if (CollectionUtils.isNullOrEmpty(results)) {
            return new ArrayList<>();
        }
        return results;
    }
}
