package com.valor.vod.cloud.mfcusercloud;

import com.google.common.collect.ImmutableMap;
import com.valor.vod.api.model.cloud.ECloudSite;
import com.valor.vod.cloud.model.database.dao.CloudBaseDao;
import com.valor.vod.cloud.model.database.ddo.*;
import common.base.tools.type.CollectionUtils;
import org.hibernate.*;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;


@Repository
@Transactional(value = "cloudTransactionManager")
public class MfcUserCloudDao extends CloudBaseDao {
    private static final Logger logger = LoggerFactory.getLogger(MfcUserCloudDao.class);

    @Autowired
    protected SessionFactory cloudSessionFactory;

    @Override
    @Transactional("cloudTransactionManager")
    public Session currentSession() {
        return this.cloudSessionFactory.getCurrentSession();
    }

    public Map<Long, MfcUserCloudDdo> getUserCloudsByAccountAndCids(long accountId, Set<Long> cids) {
        Map<Long, MfcUserCloudDdo> map = new HashMap<>();
        if (CollectionUtils.isNullOrEmpty(cids)) {
            return map;
        }
        Criteria criteria = currentSession().createCriteria(MfcUserCloudDdo.class);
        criteria.add(Restrictions.eq("accountId", accountId));
        //criteria.add(Restrictions.eq("accountType", accountType));
        criteria.add(Restrictions.in("cid", cids));
        List<MfcUserCloudDdo> ucs = criteria.list();
        if (ucs == null) {
            return map;
        }
        for (int i = 0; i < ucs.size(); i++) {
            MfcUserCloudDdo uc = ucs.get(i);
            map.put(uc.getCid(), uc);
        }
        return map;
    }

    public List<MfcUserCloudDdo> getUserCloudsByAccount(long accountId) {
        Criteria criteria = currentSession().createCriteria(MfcUserCloudDdo.class);
        criteria.add(Restrictions.eq("accountId", accountId));
        //criteria.add(Restrictions.eq("accountType", accountType));
        List<MfcUserCloudDdo> ucs = criteria.list();
        if (ucs == null) {
            return new ArrayList<>();
        }
        return ucs;
    }

    public List<MfcUserCloudDdo> getUserCloudsByAccounts(Set<Long> accountIds) {
        Criteria criteria = currentSession().createCriteria(MfcUserCloudDdo.class);
        criteria.add(Restrictions.in("accountId", accountIds));
        //criteria.add(Restrictions.eq("accountType", accountType));
        List<MfcUserCloudDdo> ucs = criteria.list();
        if (ucs == null) {
            return new ArrayList<>();
        }
        return ucs;
    }

    public MfcUserCloudMigrateDdo getUserCloudMigrateByAccount(long srcAccountId, int srcAccountType, long dstAccountId, int dstAccountType, int type) {
        Criteria criteria = currentSession().createCriteria(MfcUserCloudMigrateDdo.class);
        criteria.add(Restrictions.eq("srcAccountId", srcAccountId));
        criteria.add(Restrictions.eq("srcAccountType", srcAccountType));
        criteria.add(Restrictions.eq("dstAccountId", dstAccountId));
        criteria.add(Restrictions.eq("dstAccountType", dstAccountType));
        criteria.add(Restrictions.eq("type", type));
        List<MfcUserCloudMigrateDdo> ucs = criteria.list();
        if (CollectionUtils.isNullOrEmpty(ucs)) {
            return null;
        }
        return ucs.get(0);
    }

    //    public List<MfcUserCloudDdo> getUserClouds(long accountId, int accountType, Set<Long> cids) {
//        Criteria criteria = currentSession().createCriteria(MfcUserCloudDdo.class);
//        criteria.add(Restrictions.eq("accountId", accountId));
//        criteria.add(Restrictions.eq("accountType", accountType));
//        criteria.add(Restrictions.in("cid", cids));
//        List<MfcUserCloudDdo> ucs = criteria.list();
//        if (ucs == null){
//            return new ArrayList<>();
//        }
//        return ucs;
//    }
    public List<MfcUserCloudPkgDdo> getUserCloudPkgsByAccount(long accountId) {
        Criteria criteria = currentSession().createCriteria(MfcUserCloudPkgDdo.class);
        criteria.add(Restrictions.eq("accountId", accountId));
        //criteria.add(Restrictions.eq("accountType", accountType));
        List<MfcUserCloudPkgDdo> ucs = criteria.list();
        if (ucs == null) {
            return new ArrayList<>();
        }
        return ucs;

    }

    public List<MfcUserCloudPkgDdo> getUserCloudPkgsByAccounts(Set<Long> accountIds) {
        Criteria criteria = currentSession().createCriteria(MfcUserCloudPkgDdo.class);
        criteria.add(Restrictions.in("accountId", accountIds));
        //criteria.add(Restrictions.eq("accountType", accountType));
        List<MfcUserCloudPkgDdo> ucs = criteria.list();
        if (ucs == null) {
            return new ArrayList<>();
        }
        return ucs;

    }


    //需要重命名
    public MfcCloudPkgDdo getCloudPkg(long pkgId) {
        Criteria criteria = currentSession().createCriteria(MfcCloudPkgDdo.class);
        criteria.add(Restrictions.in("id", pkgId));
        List<MfcCloudPkgDdo> ucs = criteria.list();
        if (CollectionUtils.isNullOrEmpty(ucs)) {
            return null;
        }
        return ucs.get(0);
    }

//    public MfcCloudPkgDdo getCloudPkgBySecretKey(String secretKey){
//        Criteria criteria = currentSession().createCriteria(MfcCloudPkgDdo.class);
//        criteria.add(Restrictions.eq("secretKey", secretKey));
//        List<MfcCloudPkgDdo> ucs = criteria.list();
//        if (CollectionUtils.isNullOrEmpty(ucs)){
//            return null;
//        }
//        return ucs.get(0);
//    }

    public List<MfcCloudPkgDetailDdo> getCloudPkgDetails(long pkgId) {
        Criteria criteria = currentSession().createCriteria(MfcCloudPkgDetailDdo.class);
        criteria.add(Restrictions.eq("pkgId", pkgId));
        List<MfcCloudPkgDetailDdo> ucs = criteria.list();
        if (ucs == null) {
            return new ArrayList<>();
        }
        return ucs;
    }


    public List<MfcCloudPkgDdo> getCloudPkgs(Set<Long> pkgIds) {
        Criteria criteria = currentSession().createCriteria(MfcCloudPkgDdo.class);
        criteria.add(Restrictions.in("id", pkgIds));
        List<MfcCloudPkgDdo> ucs = criteria.list();
        if (ucs == null) {
            return new ArrayList<>();
        }
        return ucs;
    }

    public MfcCloudPkgDdo getCloudPkgByName(String pkgName) {
        Criteria criteria = currentSession().createCriteria(MfcCloudPkgDdo.class);
        criteria.add(Restrictions.in("name", pkgName));
        List<MfcCloudPkgDdo> ucs = criteria.list();
        if (CollectionUtils.isNullOrEmpty(ucs)) {
            return null;
        }
        return ucs.get(0);
    }

    public List<MfcCloudPkgDetailDdo> getCloudPkgDetails(Set<Long> pkgIds) {
        if (CollectionUtils.isNullOrEmpty(pkgIds)) {
            return new ArrayList<>();
        }
        Criteria criteria = currentSession().createCriteria(MfcCloudPkgDetailDdo.class);
        criteria.add(Restrictions.in("pkgId", pkgIds));
        List<MfcCloudPkgDetailDdo> ucs = criteria.list();
        if (ucs == null) {
            return new ArrayList<>();
        }
        return ucs;
    }

    public Map<Long, MfcUserCloudPkgHistoryDdo> getUserCloudPkgHistoriesByAccountAndPkgIds(long accountId, Set<Long> pkgIds) {
        Map<Long, MfcUserCloudPkgHistoryDdo> map = new HashMap<>();
        if (pkgIds == null) {
            return map;
        }
        Criteria criteria = currentSession().createCriteria(MfcUserCloudPkgHistoryDdo.class);
        criteria.add(Restrictions.eq("accountId", accountId));
        //criteria.add(Restrictions.eq("accountType", accountType));
        criteria.add(Restrictions.in("pkgId", pkgIds));
        List<MfcUserCloudPkgHistoryDdo> ucs = criteria.list();
        if (ucs == null) {
            return map;
        }
        for (int i = 0; i < ucs.size(); i++) {
            MfcUserCloudPkgHistoryDdo uc = ucs.get(i);
            map.put(uc.getPkgId(), uc);
        }
        return map;
    }

    public MfcUserCloudPkgHistoryDdo getUserCloudPkgHistoriesByAccountAndPkgId(long accountId, long pkgId) {
        Criteria criteria = currentSession().createCriteria(MfcUserCloudPkgHistoryDdo.class);
        criteria.add(Restrictions.eq("accountId", accountId));
        //criteria.add(Restrictions.eq("accountType", accountType));
        criteria.add(Restrictions.eq("pkgId", pkgId));
        List<MfcUserCloudPkgHistoryDdo> ucs = criteria.list();
        if (CollectionUtils.isNullOrEmpty(ucs)) {
            return null;
        }
        return ucs.get(0);
    }

    public Map<Long, MfcUserCloudPkgDdo> getUserCloudPkgsByAccountAndPkgIds(long accountId, Set<Long> pkgIds) {
        Map<Long, MfcUserCloudPkgDdo> map = new HashMap<>();
        if (CollectionUtils.isNullOrEmpty(pkgIds)) {
            return map;
        }
        Criteria criteria = currentSession().createCriteria(MfcUserCloudPkgDdo.class);
        criteria.add(Restrictions.eq("accountId", accountId));
        //criteria.add(Restrictions.eq("accountType", accountType));
        criteria.add(Restrictions.in("pkgId", pkgIds));
        List<MfcUserCloudPkgDdo> ucs = criteria.list();
        if (ucs == null) {
            return map;
        }
        for (int i = 0; i < ucs.size(); i++) {
            MfcUserCloudPkgDdo uc = ucs.get(i);
            map.put(uc.getPkgId(), uc);
        }
        return map;
    }

    public CloudAcctDdo getCloudAcctBySiteAndAcct(ECloudSite site, String acct) {
        Criteria criteria = currentSession().createCriteria(CloudAcctDdo.class);
        criteria.add(Restrictions.eq("site", site));
        criteria.add(Restrictions.eq("acct", acct));
        List<CloudAcctDdo> accts = criteria.list();
        if (CollectionUtils.isNullOrEmpty(accts)) {
            return null;
        }
        return accts.get(0);
    }

    public CloudAcctDdo getCloudAcctByCid(long cid) {
        Criteria criteria = currentSession().createCriteria(CloudAcctDdo.class);
        criteria.add(Restrictions.eq("cid", cid));
        List<CloudAcctDdo> accts = criteria.list();
        if (CollectionUtils.isNullOrEmpty(accts)) {
            return null;
        }
        return accts.get(0);
    }

    public List<CloudAcctDdo> getCloudAcctByCids(Set<Long> cids) {
        Criteria criteria = currentSession().createCriteria(CloudAcctDdo.class);
        criteria.add(Restrictions.in("cid", cids));
        List<CloudAcctDdo> accts = criteria.list();
        if (CollectionUtils.isNullOrEmpty(accts)) {
            return new ArrayList<>();
        }
        return accts;
    }

    public MfcCloudPkgExportDdo getCloudPkgExportByPkgId(long pkgId) {
        Criteria criteria = currentSession().createCriteria(MfcCloudPkgExportDdo.class);
        criteria.add(Restrictions.eq("id", pkgId));
        List<MfcCloudPkgExportDdo> pkgs = criteria.list();
        if (CollectionUtils.isNullOrEmpty(pkgs)) {
            return null;
        }
        return pkgs.get(0);
    }

    public List<MfcCloudPkgExportDdo> getCloudPkgExportByPkgIds(Set<Long> pkgIds) {
        Criteria criteria = currentSession().createCriteria(MfcCloudPkgExportDdo.class);
        criteria.add(Restrictions.in("id", pkgIds));
        List<MfcCloudPkgExportDdo> pkgs = criteria.list();
        if (CollectionUtils.isNullOrEmpty(pkgs)) {
            return new ArrayList<>();
        }
        return pkgs;
    }

    public MfcCloudPkgExportDdo getCloudPkgExportBySecretKey(String secretKey) {
        Criteria criteria = currentSession().createCriteria(MfcCloudPkgExportDdo.class);
        criteria.add(Restrictions.eq("secretKey", secretKey));
        List<MfcCloudPkgExportDdo> pkgs = criteria.list();
        if (CollectionUtils.isNullOrEmpty(pkgs)) {
            return null;
        }
        return pkgs.get(0);
    }

    public List<MfcCloudPkgDetailExportDdo> getCloudPkgDetailExportsByPkgId(long pkgId) {
        Criteria criteria = currentSession().createCriteria(MfcCloudPkgDetailExportDdo.class);
        criteria.add(Restrictions.eq("pkgId", pkgId));
        List<MfcCloudPkgDetailExportDdo> details = criteria.list();
        if (CollectionUtils.isNullOrEmpty(details)) {
            return new ArrayList<>();
        }
        return details;
    }

    /**
     * 查询未开户的网盘
     */
    public List<MfcCloudPkgDetailExportDdo> getValidCloudPkgDetailExport(long pkgId) {
        Criteria criteria = currentSession().createCriteria(MfcCloudPkgDetailExportDdo.class);
        criteria.add(Restrictions.eq("pkgId", pkgId));
        criteria.add(Restrictions.eq("cid", -1L));
        List<MfcCloudPkgDetailExportDdo> details = criteria.list();
        if (CollectionUtils.isNullOrEmpty(details)) {
            return new ArrayList<>();
        }
        return details;
    }

    /**
     * 查询未开户的网盘
     */
    public MfcCloudPkgDetailDdo getValidCloudPkgDetail(long pkgId, String site, String name) {
        Criteria criteria = currentSession().createCriteria(MfcCloudPkgDetailDdo.class);
        criteria.add(Restrictions.eq("pkgId", pkgId));
        criteria.add(Restrictions.eq("acctSite", site));
        criteria.add(Restrictions.eq("acctUserName", name));
        criteria.add(Restrictions.eq("cid", -1L));
        List<MfcCloudPkgDetailDdo> details = criteria.list();
        if (CollectionUtils.isNullOrEmpty(details)) {
            return new MfcCloudPkgDetailDdo();
        }
        return details.get(0);
    }

    public List<MfcCloudPkgDetailExportDdo> getCloudPkgDetailExportsByPkgIds(Set<Long> pkgIds) {
        Criteria criteria = currentSession().createCriteria(MfcCloudPkgDetailExportDdo.class);
        criteria.add(Restrictions.in("pkgId", pkgIds));
        List<MfcCloudPkgDetailExportDdo> details = criteria.list();
        if (CollectionUtils.isNullOrEmpty(details)) {
            return new ArrayList<>();
        }
        return details;
    }

    public List<VendorCloudPkgDdo> loadVendorCloudPkgs() {
        Criteria criteria = currentSession().createCriteria(VendorCloudPkgDdo.class);
        List<VendorCloudPkgDdo> pkgs = criteria.list();
        if (pkgs == null) {
            pkgs = new ArrayList<>();
        }
        return pkgs;
    }

    public VendorCloudPkgDdo getVendorCloudPkgByVendorIdAndPkgId(long vendorId, long pkgId) {
        Criteria criteria = currentSession().createCriteria(VendorCloudPkgDdo.class);
        criteria.add(Restrictions.eq("vendorId", vendorId));
        criteria.add(Restrictions.eq("pkgId", pkgId));
        List<VendorCloudPkgDdo> pkgs = criteria.list();
        if (CollectionUtils.isNullOrEmpty(pkgs)) {
            return null;
        }
        return pkgs.get(0);
    }

    public List<VendorCloudPkgDdo> getVendorCloudPkgsByPkgId(long pkgId) {
        Criteria criteria = currentSession().createCriteria(VendorCloudPkgDdo.class);
        criteria.add(Restrictions.eq("pkgId", pkgId));
        List<VendorCloudPkgDdo> pkgs = criteria.list();
        if (CollectionUtils.isNullOrEmpty(pkgs)) {
            return new ArrayList<>();
        }
        return pkgs;
    }

    public List<CloudAcctDdo> getCloudAccts(Set<Long> cids) {
        List<CloudAcctDdo> cloudList = getListDataIn(false, CloudAcctDdo.class, ImmutableMap.of("cid", cids));
        return cloudList;
    }


//    public Set<String> getAllAccounts(int limit){
//        Set<String> accountSet = new HashSet<>();
//
//        StringBuilder sqlSb = new StringBuilder();
//        if (limit == 0){
//            sqlSb.append("select distinct(concat(account_id,'_',account_type)) id from user_cloud union select distinct(concat(account_id,'_',account_type)) id from user_public_cloud");
//        }
//        else{
//            sqlSb.append("select * from ((select distinct(concat(account_id,'_',account_type)) id from user_cloud limit "+limit+") union (select distinct(concat(account_id,'_',account_type)) id from user_public_cloud limit "+limit+")) t limit "+limit);
//        }
//
//        logger.info("getAllAccounts(),get account_id,account_type data from db,{}",sqlSb.toString());
//
//        SQLQuery sqlQuery = currentSession().createSQLQuery(sqlSb.toString());
//        Iterator it = sqlQuery.list().iterator();
//
//        logger.info("getAllAccounts(),parse account_id data");
//
//        while(it.hasNext()){
//            Object o = it.next();
//            try {
//                accountSet.add(o.toString());
//            }
//            catch (Exception ex){
//                logger.error("getAllAccounts(),parse account exception,{}",ex.getMessage());
//                throw ex;
//            }
//
//        }
//        logger.info("getAllAccounts(),parse account {} records.",accountSet.size());
//
//        return accountSet;
//    }
}
