package com.valor.vod.cloud.mfcusercloud;


import com.valor.vod.api.common.ListTool;
import com.valor.vod.api.common.MapTool;
import com.valor.vod.api.common.SetTool;
import com.valor.vod.api.model.cloud.ECloudAcctType;
import com.valor.vod.cloud.blackGrey.CloudAcctBgDao;
import com.valor.vod.cloud.blackGrey.CloudPkgBgDao;
import com.valor.vod.cloud.cache.CloudRedisCache;
import com.valor.vod.cloud.model.database.ddo.*;
import com.valor.vod.cloud.model.database.dto.MfcCloudPkgDto;
import com.valor.vod.cloud.model.database.dto.MfcUserCloudPkgDto;
import com.valor.vod.common.tools.type.CollectionUtils;
import common.config.tools.config.ConfigTools3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Service("mfcUserCloudService")
public class MfcUserCloudServiceImpl implements MfcUserCloudService {
    private static final Logger logger = LoggerFactory.getLogger(MfcUserCloudServiceImpl.class);

    //    @Autowired
//    VendorCloudCache vendorCloudCache;
    @Autowired
    VendorCloudPkgCache vendorCloudPkgCache;

    @Autowired
    MfcUserCloudDao mfcUserCloudDao;

    //    @Autowired
//    MFCRedisUtil mfcRedisUtil;
    @Autowired
    CloudRedisCache cloudRedisCache;

    @Autowired
    CloudPkgCacheService cloudPkgCacheService;
    @Autowired
    CidSummaryService cidSummaryService;

    @Autowired
    CloudAcctBgDao cloudAcctBgDao;

    @Autowired
    CloudPkgBgDao cloudPkgBgDao;

    @Override
    public void setUserCloud(MfcUserCloudDdo userCloud) {
        setUserClouds(userCloud.getAccountId(), ListTool.toList(userCloud));
    }

    @Override
    public void setUserClouds(List<MfcUserCloudDdo> userClouds) {
        Map<String, List<MfcUserCloudDdo>> accountMap = getAccountCloudsMap(userClouds);
        for (Map.Entry<String, List<MfcUserCloudDdo>> e : accountMap.entrySet()) {
            //String[] kv = e.getKey().split("_");
            //long accountId = Long.parseLong(kv[0]);
            //int accountType = Integer.parseInt(kv[1]);
            long accountId = Long.parseLong(e.getKey());
            setUserClouds(accountId, e.getValue());
        }
    }

    //增加用户网盘关系记录
    @Override
    public void setUserClouds(long accountId, List<MfcUserCloudDdo> userClouds) {
        if (CollectionUtils.isNullOrEmpty(userClouds)) {
            return;
        }
        List<MfcUserCloudDdo> ucDdos = new ArrayList<>();
        Set<Long> cids = userClouds.stream().map(MfcUserCloudDdo::getCid).collect(Collectors.toSet());
        Map<Long, MfcUserCloudDdo> ucMap = mfcUserCloudDao.getUserCloudsByAccountAndCids(accountId, cids);
        for (MfcUserCloudDdo uc : userClouds) {
            MfcUserCloudDdo ucDdo = MapTool.get(ucMap, uc.getCid());
            if (ucDdo == null) {
                ucDdo = new MfcUserCloudDdo();
            }
            ucDdo.setAccountId(accountId);
            //ucDdo.setAccountType(accountType);
            ucDdo.setAcctAlias(uc.getAcctAlias());
            ucDdo.setAcctType(uc.getAcctType());
            ucDdo.setExpiredTime(uc.getExpiredTime());
            ucDdo.setCid(uc.getCid());
            ucDdo.setPkgId(uc.getPkgId());
            ucDdo.setLastModifyTime(new Date());
            ucDdos.add(ucDdo);
        }

        if (!CollectionUtils.isNullOrEmpty(ucDdos)) {
            mfcUserCloudDao.storeAll(ucDdos);
        }

        refreshAccount(accountId);
    }

    @Override
    public void clearAccount(long accountId) {
        //如果存在，删除用户网盘关系表记录
        List<MfcUserCloudDdo> mfcUserClouds = mfcUserCloudDao.getUserCloudsByAccount(accountId);
        List<MfcUserCloudPkgDdo> mfcUserCloudPkgs = mfcUserCloudDao.getUserCloudPkgsByAccount(accountId);
        List<Object> toDels = new ArrayList<>();
        if (!CollectionUtils.isNullOrEmpty(mfcUserClouds)) {
            toDels.addAll(mfcUserClouds);
        }
        if (!CollectionUtils.isNullOrEmpty(mfcUserCloudPkgs)) {
            toDels.addAll(mfcUserCloudPkgs);
        }
        mfcUserCloudDao.deleteAll(toDels);
        refreshAccount(accountId);
    }

    @Override
    public void delUserCloud(MfcUserCloudDdo userCloud) {
        delUserClouds(userCloud.getAccountId(), SetTool.asHashSet(userCloud.getCid()));
    }

    @Override
    public void delUserClouds(List<MfcUserCloudDdo> userClouds) {
        Map<String, List<MfcUserCloudDdo>> accountMap = getAccountCloudsMap(userClouds);
        for (Map.Entry<String, List<MfcUserCloudDdo>> e : accountMap.entrySet()) {
            //String[] kv = e.getKey().split("_");
            //long accountId = Long.parseLong(kv[0]);
            long accountId = Long.parseLong(e.getKey());
            //int accountType = Integer.parseInt(kv[1]);
            Set<Long> cidSet = new HashSet<>();
            if (!CollectionUtils.isNullOrEmpty(e.getValue())) {
                for (int i = 0; i < e.getValue().size(); i++) {
                    MfcUserCloudDdo uc = e.getValue().get(i);
                    cidSet.add(uc.getCid());
                }
            }
            delUserClouds(accountId, cidSet);
        }
    }

    //删除用户网盘关系记录
    @Override
    public void delUserClouds(long accountId, Set<Long> cids) {

        if (CollectionUtils.isNullOrEmpty(cids)) {
            return;
        }

        //如果存在，删除用户网盘关系表记录
        Map<Long, MfcUserCloudDdo> mfcUserCloudDdos = mfcUserCloudDao.getUserCloudsByAccountAndCids(accountId, cids);
        if (!CollectionUtils.isNullOrEmpty(mfcUserCloudDdos)) {
            mfcUserCloudDao.deleteAll(mfcUserCloudDdos.values());
        }

        refreshAccount(accountId);
    }

    @Override
    public List<MfcUserCloudDdo> getUserCloudsByAccount(long accountId) {
        //String key = "user-cloud-" + accountId + "-" + accountType;
        String key = "user-cloud-" + accountId;
        List<MfcUserCloudDdo> userClouds = (List<MfcUserCloudDdo>) cloudRedisCache.get(key);
        if (userClouds != null) {
            return userClouds;
        }
        //没有了,或异常了，重新加载
        try {
            RefreshAccountEntity result = refreshAccount(accountId);
            return result.getUserClouds();
        } catch (Exception ex) {
            logger.error("getUserCloudsByAccount(),exception.", ex);
            return null;
        }
    }

    @Override
    public Map<Long, UserCloudCidSummary> getCidSummaryByAccount(long accountId) {
        //String key = "user-cids-" + accountId + "-" + accountType;
        String key = "user-cids-" + accountId;
        Set<String> valueSet = (Set<String>) cloudRedisCache.get(key);
        if (valueSet != null) {
            return cidSummaryService.toObjects(valueSet);
        }
        //没有了,或异常了，重新加载
        try {
            RefreshAccountEntity result = refreshAccount(accountId);
            List<Long> cidBg = getCidBg(result);

            Map<Long, UserCloudCidSummary> map = new HashMap<>();
            if (!CollectionUtils.isNullOrEmpty(result.getMergedUserClouds())) {
                for (int i = 0; i < result.getMergedUserClouds().size(); i++) {
                    UserCloudCidSummary cidSummary = cidSummaryService.toSummary(result.getMergedUserClouds().get(i), cidBg);
                    if (cidSummary == null) {
                        continue;
                    }
                    map.put(cidSummary.getCid(), cidSummary);
                }
            }
            return map;
        } catch (Exception ex) {
            logger.error("getCidSummaryByAccount(),exception.", ex);
            return null;
        }
    }

    private List<Long> getCidBg(RefreshAccountEntity result) {
        List<Long> cidBg = new ArrayList<>();
        List<MfcUserCloudPkgDdo> userCloudPkgs = result.getUserCloudPkgs();
        List<MfcUserCloudDdo> userClouds = result.getUserClouds();
        // 过滤掉当前用户，在黑名单的网盘包下所有网盘
        if (!CollectionUtils.isNullOrEmpty(userCloudPkgs)) {
            Set<Long> pkgIds = userCloudPkgs.stream().map(MfcUserCloudPkgDdo::getPkgId).collect(Collectors.toSet());
            List<Long> bgPkgIds = cloudPkgBgDao.queryBlackList(pkgIds);
            if (!CollectionUtils.isNullOrEmpty(bgPkgIds)) {
                Set<Long> cids = new HashSet<>();
                // 获取网盘包下所有网盘
                Map<Long, MfcCloudPkgDto> pkgsByPkgIds = cloudPkgCacheService.getCloudPkgsByPkgIds(pkgIds);
                List<Long> diff = pkgIds.stream().filter(s -> !bgPkgIds.contains(s)).collect(Collectors.toList());

                for (Long pkgId : bgPkgIds) {
                    List<Long> collect = pkgsByPkgIds.get(pkgId).getMfcCloudPkgDetails().stream().map(MfcCloudPkgDetailDdo::getCid).collect(Collectors.toList());
                    cids.addAll(collect);
                }
                for (Long pkgId : diff) {
                    List<Long> collect = pkgsByPkgIds.get(pkgId).getMfcCloudPkgDetails().stream().map(MfcCloudPkgDetailDdo::getCid).collect(Collectors.toList());
                    cids.removeAll(collect);
                }
                cidBg.addAll(cids);
            }
        }

        // 过滤掉黑名单的网盘
        if (!CollectionUtils.isNullOrEmpty(userClouds)) {
            List<Long> cids = userClouds.stream().map(MfcUserCloudDdo::getCid).collect(Collectors.toList());
            List<Long> bgCids = cloudAcctBgDao.queryBlackList(cids);
            if (!CollectionUtils.isNullOrEmpty(bgCids)) {
                cidBg.addAll(bgCids);
            }
        }
        return cidBg;
    }

    //同一个账号只会加一次同样的网盘
    @Override
    public Map<Long, MfcUserCloudDdo> getUserCloudsOfCidMapByAccount(long accountId) {
        List<MfcUserCloudDdo> clouds = getUserCloudsByAccount(accountId);
        Map<Long, MfcUserCloudDdo> map = new HashMap<>();
        if (!CollectionUtils.isNullOrEmpty(clouds)) {
            map = clouds.stream().collect(Collectors.toMap(MfcUserCloudDdo::getCid, cloud -> cloud));
        }
        return map;
    }

    @Override
    public List<MfcUserCloudDdo> getMergedUserCloudsByAccount(long accountId) {
        Map<Long, MfcUserCloudDdo> map = getMergedUserCloudsOfCidMapByAccount(accountId);
        return new ArrayList<>(map.values());
    }

    private void getUserCloudsAndUserCloudPkgsByAccount(long accountId
        , List<MfcUserCloudDdo> userClouds, List<MfcUserCloudPkgDdo> userCloudPkgs) {
        String ucKey = "user-cloud-" + accountId;
        String ucpKey = "user-cloud-pkg-" + accountId;
        Set<String> keys = new HashSet<>();
        keys.add(ucKey);
        keys.add(ucpKey);
        Map<String, Object> redisObjs = cloudRedisCache.mGet(keys);

        List<MfcUserCloudDdo> ucs = null;
        if (redisObjs != null && redisObjs.containsKey(ucKey) && redisObjs.get(ucKey) != null) {
            ucs = (List<MfcUserCloudDdo>) redisObjs.get(ucKey);
        }

        List<MfcUserCloudPkgDdo> ucps = null;
        if (redisObjs != null && redisObjs.containsKey(ucpKey) && redisObjs.get(ucpKey) != null) {
            ucps = (List<MfcUserCloudPkgDdo>) redisObjs.get(ucpKey);
        }
        if (ucs != null && ucps != null) {
            userClouds.clear();
            userCloudPkgs.clear();
            userClouds.addAll(ucs);
            userCloudPkgs.addAll(ucps);
            return;
        }

        //没有了,或异常了，重新加载
        try {
            RefreshAccountEntity result = refreshAccount(accountId);

            userClouds.clear();
            userCloudPkgs.clear();
            if (!CollectionUtils.isNullOrEmpty(result.getUserClouds())) {
                userClouds.addAll(result.getUserClouds());
            }
            if (!CollectionUtils.isNullOrEmpty(result.getUserCloudPkgs())) {
                userCloudPkgs.addAll(result.getUserCloudPkgs());
            }
        } catch (Exception ex) {
            logger.error("getUserCloudsByAccount(),exception.", ex);
        }

    }

    @Override
    public Map<Long, MfcUserCloudDdo> getMergedUserCloudsOfCidMapByAccount(long accountId) {
//        List<MfcUserCloudDdo> userClouds = getUserCloudsByAccount(accountId,accountType);
//        List<MfcUserCloudPkgDdo> userCloudPkgs = getUserCloudPkgsByAccount(accountId,accountType);
//        if (userClouds == null){
//            userClouds = new ArrayList<>();
//        }
//        if (userCloudPkgs == null){
//            userCloudPkgs = new ArrayList<>();
//        }
        List<MfcUserCloudDdo> userClouds = new ArrayList<>();
        List<MfcUserCloudPkgDdo> userCloudPkgs = new ArrayList<>();
        getUserCloudsAndUserCloudPkgsByAccount(accountId, userClouds, userCloudPkgs);

        Set<Long> pkgIds = userCloudPkgs.stream().map(MfcUserCloudPkgDdo::getPkgId).collect(Collectors.toSet());
        Map<Long, MfcCloudPkgDto> dtoMap = cloudPkgCacheService.getCloudPkgsByPkgIds(pkgIds);

        List<MfcUserCloudDdo> mergedUserClouds = merge(accountId, userClouds, userCloudPkgs, dtoMap);
        return mergedUserClouds.stream().collect(Collectors.toMap(MfcUserCloudDdo::getCid, item -> item));
    }

    @Override
    public MfcUserCloudDdo getMergedUserCloudByAccountAndCid(long accountId, long cid) {
        Map<Long, MfcUserCloudDdo> map = getMergedUserCloudsOfCidMapByAccount(accountId);
        return map.get(cid);
    }

    @Override
    public Map<Long, MfcCloudPkgDto> getCloudPkgsByAccount(long accountId) {
        List<MfcUserCloudPkgDdo> userCloudPkgs = getUserCloudPkgsByAccount(accountId);
        if (userCloudPkgs == null) {
            userCloudPkgs = new ArrayList<>();
        }
        Set<Long> pkgIds = userCloudPkgs.stream().map(MfcUserCloudPkgDdo::getPkgId).collect(Collectors.toSet());
        return cloudPkgCacheService.getCloudPkgsByPkgIds(pkgIds);
    }

    @Override
    public Map<Long, MfcUserCloudPkgDto> getUserCloudPkgDtosByAccount(long accountId) {
        Map<Long, MfcUserCloudPkgDto> map = new HashMap<>();
        List<MfcUserCloudPkgDdo> userCloudPkgs = getUserCloudPkgsByAccount(accountId);
        if (CollectionUtils.isNullOrEmpty(userCloudPkgs)) {
            return map;
        }
        Set<Long> pkgIds = userCloudPkgs.stream().map(MfcUserCloudPkgDdo::getPkgId).collect(Collectors.toSet());
        Map<Long, MfcCloudPkgDto> dtoMap = cloudPkgCacheService.getCloudPkgsByPkgIds(pkgIds);
        if (CollectionUtils.isNullOrEmpty(dtoMap)) {
            return map;
        }

        for (MfcUserCloudPkgDdo ucp : userCloudPkgs) {
            if (!dtoMap.containsKey(ucp.getPkgId())) {
                continue;
            }
            MfcCloudPkgDto dto = dtoMap.get(ucp.getPkgId());
            if (dto == null) {
                continue;
            }
            MfcUserCloudPkgDto d = new MfcUserCloudPkgDto();
            d.setMfcUserCloudPkg(ucp);
            d.setMfcCloudPkgDetails(dto.getMfcCloudPkgDetails());
            d.setMfcCloudPkg(dto.getMfcCloudPkg());
            map.put(ucp.getPkgId(), d);
        }

        return map;
    }

    @Override
    public MfcCloudPkgDto getCloudPkgByAccountAndPkgId(long accountId, long pkgId) {
        Map<Long, MfcCloudPkgDto> map = getCloudPkgsByAccount(accountId);
        return map.get(pkgId);
    }

//    @Override
//    public Map<Long, MfcCloudPkgDto> getCloudPkgsByPkgIds(Set<Long> pkgIds) {
//        Map<Long,MfcCloudPkgDto> map = cloudPkgCacheService.getCloudPkgs(pkgIds);
//        return map;
//    }

//    @Override
//    public MfcCloudPkgDto getCloudPkgBySecretKey(String secretKey){
//        MfcCloudPkgDto dto = cloudPkgCacheService.getCloudPkgBySecretKeyByDb(secretKey);
//        return dto;
//    }


    @Override
    public MfcUserCloudDdo getUserCloudsByAccountAndCid(long accountId, long cid) {
        List<MfcUserCloudDdo> userClouds = getUserCloudsByAccount(accountId);
        Map<Long, MfcUserCloudDdo> cidMap = new HashMap<>();
        if (!CollectionUtils.isNullOrEmpty(userClouds)) {
            for (MfcUserCloudDdo userCloud : userClouds) {
                cidMap.put(userCloud.getCid(), userCloud);
            }
        }
        if (cidMap.containsKey(cid)) {
            return cidMap.get(cid);
        }
        return null;
    }

    @Override
    public MfcUserCloudPkgDdo getUserCloudPkgsByAccountAndPkgId(long accountId, long pkgId) {
        Map<Long, MfcUserCloudPkgDdo> map = getUserCloudPkgsOfPkgIdMapByAccount(accountId);
        return map.get(pkgId);
    }

    @Override
    public List<MfcUserCloudPkgDdo> getUserCloudPkgsByAccount(long accountId) {
        String key = "user-cloud-pkg-" + accountId;

        List<MfcUserCloudPkgDdo> userClouds = cloudRedisCache.get(key);
        if (userClouds != null) {
            return userClouds;
        }
        //没有了,或异常了，重新加载
        try {
            RefreshAccountEntity result = refreshAccount(accountId);
            return result.getUserCloudPkgs();
        } catch (Exception ex) {
            logger.error("getUserCloudsByAccount(),exception.", ex);
            return null;
        }
    }

    @Override
    public Map<Long, MfcUserCloudPkgDdo> getUserCloudPkgsOfPkgIdMapByAccount(long accountId) {
        Map<Long, MfcUserCloudPkgDdo> map = new HashMap<>();
        List<MfcUserCloudPkgDdo> pkgs = getUserCloudPkgsByAccount(accountId);
        if (!CollectionUtils.isNullOrEmpty(pkgs)) {
            for (MfcUserCloudPkgDdo pkg : pkgs) {
                map.put(pkg.getPkgId(), pkg);
            }
        }
        return map;
    }

    @Override
    public void setUserCloudPkg(MfcUserCloudPkgDdo userCloudPkg) {
        setUserCloudPkgs(ListTool.toList(userCloudPkg));
    }

    @Override
    public void setUserCloudPkgs(long accountId, List<MfcUserCloudPkgDdo> userCloudPkgs) {
        if (CollectionUtils.isNullOrEmpty(userCloudPkgs)) {
            return;
        }

        List<MfcUserCloudPkgDdo> ucDdos = new ArrayList<>();
        //List<MfcUserCloudPkgHistoryDdo> toAddHistories = new ArrayList<>();
        //检查超时时间
        Set<Long> pkgIds = userCloudPkgs.stream().map(MfcUserCloudPkgDdo::getPkgId).collect(Collectors.toSet());
        Map<Long, MfcUserCloudPkgDdo> ucMap = mfcUserCloudDao.getUserCloudPkgsByAccountAndPkgIds(accountId, pkgIds);
        //Map<Long,MfcUserCloudPkgHistoryDdo> ucHistoryMap = mfcUserCloudDao.getUserCloudPkgHistoriesByAccountAndPkgIds(accountId, pkgIds);
        for (MfcUserCloudPkgDdo uc : userCloudPkgs) {
            //history
//            MfcUserCloudPkgHistoryDdo ucHistoryDdo = MapTool.get(ucHistoryMap,uc.getPkgId());
//            if (ucHistoryDdo == null){
//                MfcUserCloudPkgHistoryDdo h = new MfcUserCloudPkgHistoryDdo();
//                h.setAccountId(accountId);
//                //h.setAccountType(accountType);
//                h.setPkgId(uc.getPkgId());
//                h.setExpiredTime(uc.getExpiredTime());
//                toAddHistories.add(h);
//            }

            //pkg
            MfcUserCloudPkgDdo ucDdo = MapTool.get(ucMap, uc.getPkgId());
            if (ucDdo == null) {
                ucDdo = new MfcUserCloudPkgDdo();
            }
            ucDdo.setAccountId(accountId);
            //ucDdo.setAccountType(accountType);
            ucDdo.setPkgId(uc.getPkgId());
//            if (ucHistoryDdo != null){
//                ucDdo.setExpiredTime(ucHistoryDdo.getExpiredTime());
//            }
//            else{
//                ucDdo.setExpiredTime(uc.getExpiredTime());
//            }
            ucDdo.setExpiredTime(uc.getExpiredTime());
            ucDdo.setLastModifyTime(new Date());
            ucDdos.add(ucDdo);
        }

        if (!CollectionUtils.isNullOrEmpty(ucDdos)) {
            mfcUserCloudDao.storeAll(ucDdos);
        }
//        if (!CollectionUtils.isNullOrEmpty(toAddHistories)){
//            mfcUserCloudDao.storeAll(toAddHistories);
//        }
        refreshAccount(accountId);
    }

    private Map<String, List<MfcUserCloudPkgDdo>> getAccountCloudPkgMap(List<MfcUserCloudPkgDdo> userCloudPkgs) {
        Map<String, List<MfcUserCloudPkgDdo>> result = new HashMap<>();
        if (CollectionUtils.isNullOrEmpty(userCloudPkgs)) {
            return result;
        }
        for (MfcUserCloudPkgDdo uc : userCloudPkgs) {
            String key = String.valueOf(uc.getAccountId());
            List<MfcUserCloudPkgDdo> list;
            if (result.containsKey(key)) {
                list = result.get(key);
            } else {
                list = new ArrayList<>();
                result.put(key, list);
            }
            list.add(uc);
        }
        return result;
    }

    @Override
    public void setUserCloudPkgs(List<MfcUserCloudPkgDdo> userCloudPkgs) {
        //检查超时时间
        if (CollectionUtils.isNullOrEmpty(userCloudPkgs)) {
            return;
        }
        Map<String, List<MfcUserCloudPkgDdo>> accountMap = getAccountCloudPkgMap(userCloudPkgs);
        for (Map.Entry<String, List<MfcUserCloudPkgDdo>> e : accountMap.entrySet()) {
            String key = e.getKey();
            //String[] items = key.split("_");
            //long accountId = Long.parseLong(items[0]);
            //int accountType = Integer.parseInt(items[1]);
            long accountId = Long.parseLong(key);
            List<MfcUserCloudPkgDdo> ucPkgs = e.getValue();
            setUserCloudPkgs(accountId, ucPkgs);
        }
    }

//    private void refreshUserCloudPkg(List<MfcUserCloudPkgDdo> userCloudPkgs){
//        Set<String> keySet = new HashSet<>();
//        for(int i=0;i<userCloudPkgs.size();i++){
//            MfcUserCloudPkgDdo uc = userCloudPkgs.get(i);
//            String key = uc.getAccountId() + "_" + uc.getAccountType();
//            keySet.add(key);
//        }
//        for(String key :keySet){
//            String[] items = key.split("_");
//            long accountId = Long.parseLong(items[0]);
//            int accountType = Integer.parseInt(items[1]);
//            refreshAccount(accountId,accountType);
//        }
//    }

    @Override
    public void delUserCloudPkg(MfcUserCloudPkgDdo userCloudPkg) {
        delUserCloudPkgs(ListTool.toList(userCloudPkg));
    }

    @Override
    public void delUserCloudPkgs(long accountId, Set<Long> pkgIds) {
        Map<Long, MfcUserCloudPkgDdo> pkgMap = mfcUserCloudDao.getUserCloudPkgsByAccountAndPkgIds(accountId, pkgIds);
        List<MfcUserCloudPkgDdo> pkgs = new ArrayList<>(pkgMap.values());
        if (pkgs.size() != 0) {
            mfcUserCloudDao.deleteAll(pkgs);
        }
        refreshAccount(accountId);
    }

    @Override
    public void delUserCloudPkgs(List<MfcUserCloudPkgDdo> userCloudPkgs) {
        if (CollectionUtils.isNullOrEmpty(userCloudPkgs)) {
            return;
        }
        Map<String, List<MfcUserCloudPkgDdo>> accountMap = getAccountCloudPkgMap(userCloudPkgs);
        for (Map.Entry<String, List<MfcUserCloudPkgDdo>> e : accountMap.entrySet()) {
            String key = e.getKey();
            String[] items = key.split("_");
            long accountId = Long.parseLong(items[0]);
            //int accountType = Integer.parseInt(items[1]);
            Set<Long> pkgIds = e.getValue().stream().map(MfcUserCloudPkgDdo::getPkgId).collect(Collectors.toSet());
            delUserCloudPkgs(accountId, pkgIds);
        }
    }

    @Override
    public MfcUserCloudDdo getUserCloudsByAccountAndCidAndAccType(long accountId, long cid, boolean onlyPrivate) {
        List<MfcUserCloudDdo> userClouds = getUserCloudsByAccount(accountId);
        Map<Long, MfcUserCloudDdo> cidMap = new HashMap<>();
        if (!CollectionUtils.isNullOrEmpty(userClouds)) {
            for (MfcUserCloudDdo userCloud : userClouds) {
                cidMap.put(userCloud.getCid(), userCloud);
            }
        }
        if (cidMap.containsKey(cid)) {
            MfcUserCloudDdo userCloud = cidMap.get(cid);
            if (onlyPrivate) {
                if (userCloud.getAcctType() == ECloudAcctType.PRIVATE.ordinal()) {
                    return userCloud;
                }
            } else {
                return userCloud;
            }
        }
        return null;
    }


    @Override
    public void resetClouds(Set<Long> accountIds, List<MfcUserCloudDdo> mfcUserClouds, List<MfcUserCloudPkgDdo> mfcUserCloudPkgs
        , Map<Long, List<MfcUserCloudDdo>> newUserClouds, Map<Long, List<MfcUserCloudPkgDdo>> newUserCloudPkgs) {
        List<Object> toDels = new ArrayList<>();
        toDels.addAll(mfcUserClouds);
        toDels.addAll(mfcUserCloudPkgs);
        if (toDels.size() != 0) {
            mfcUserCloudDao.deleteAll(toDels);
        }
        List<Object> toAdds = new ArrayList<>();
        for (Map.Entry<Long, List<MfcUserCloudDdo>> e : newUserClouds.entrySet()) {
            toAdds.addAll(e.getValue());
        }
        for (Map.Entry<Long, List<MfcUserCloudPkgDdo>> e : newUserCloudPkgs.entrySet()) {
            toAdds.addAll(e.getValue());
        }
        if (toAdds.size() != 0) {
            mfcUserCloudDao.storeAll(toAdds);
        }
        clearAccountCaches(accountIds);
    }

    private void clearAccountCaches(Set<Long> accountIds) {
        Set<String> keys = new HashSet<>();
        for (Long accountId : accountIds) {
            String key = "user-cloud-" + accountId;
            keys.add(key);

            String pkgKey = "user-cloud-pkg-" + accountId;
            keys.add(pkgKey);

            String ucKey = "user-cids-" + accountId;
            keys.add(ucKey);
        }
        cloudRedisCache.del(keys.toArray(new String[0]));
    }

    // 刷新用户的网盘与网盘包
    private RefreshAccountEntity refreshAccount(long accountId) {
        RefreshAccountEntity entity = new RefreshAccountEntity();
        try {
            //user cloud
            List<MfcUserCloudDdo> userCloudsOfDb = getCloudByAccountByDb(accountId);
            //user pkg
            List<MfcUserCloudPkgDdo> userCloudPkgsOfDb = getCloudPkgByAccountByDb(accountId);
            //redis
            setUserCloudRedis(accountId, userCloudsOfDb, userCloudPkgsOfDb, entity);

            entity.setUserClouds(userCloudsOfDb);
            entity.setUserCloudPkgs(userCloudPkgsOfDb);
        } catch (Exception ex) {
            logger.error("refreshAccount(),exception.{}", ex);
        }
        return entity;
    }

    private void setUserCloudRedis(long accountId
        , List<MfcUserCloudDdo> userClouds
        , List<MfcUserCloudPkgDdo> userCloudPkgs
        , RefreshAccountEntity entity) {
        if (userClouds == null) {
            return;
        }
        try {
            String key = "user-cloud-" + accountId;
            long expiredTime = ConfigTools3.getLong("mfc.cloudapi.refreshUserCloud.periodSeconds", 14400L);
            cloudRedisCache.setEx(key, userClouds, expiredTime);
            //将user-cloud收缩成user-pkg,redis内存会少用很多
            String pkgKey = "user-cloud-pkg-" + accountId;
            long pkgExpiredTime = ConfigTools3.getLong("mfc.cloudapi.refreshUserCloudPkg.periodSeconds", 14400L);
            cloudRedisCache.setEx(pkgKey, userCloudPkgs, pkgExpiredTime);

            Set<Long> pkgIds = userCloudPkgs.stream().map(MfcUserCloudPkgDdo::getPkgId).collect(Collectors.toSet());
            Map<Long, MfcCloudPkgDto> cloudPkgsOfDb = getCloudPkgsByPkgIdByDb(pkgIds);
            List<MfcUserCloudDdo> mergedClouds = merge(accountId, userClouds, userCloudPkgs, cloudPkgsOfDb);
            String ucKey = "user-cids-" + accountId;
            long ucExpiredTime = ConfigTools3.getLong("mfc.cloudapi.refreshUserCids.periodSeconds", 14400L);
            Set<String> cidSummarySet = cidSummaryService.toString(mergedClouds);
            cloudRedisCache.setEx(ucKey, cidSummarySet, ucExpiredTime);
            entity.setCloudPkgs(cloudPkgsOfDb);
            entity.setMergedUserClouds(mergedClouds);
        } catch (Exception ex) {
            logger.error("setUserCloudRedis(),exception.", ex);
        }
    }

    private List<MfcUserCloudDdo> merge(long accountId, List<MfcUserCloudDdo> userClouds, List<MfcUserCloudPkgDdo> userCloudPkgs, Map<Long, MfcCloudPkgDto> cloudPkgs) {
        List<MfcUserCloudDdo> ucs = new ArrayList<>();

        if (userCloudPkgs != null && cloudPkgs != null) {
            for (MfcUserCloudPkgDdo userCloudPkg : userCloudPkgs) {
                MfcCloudPkgDto dto = cloudPkgs.get(userCloudPkg.getPkgId());
                if (dto == null || dto.getMfcCloudPkg() == null || CollectionUtils.isNullOrEmpty(dto.getMfcCloudPkgDetails())) {
                    continue;
                }
                MfcCloudPkgDdo pkg = dto.getMfcCloudPkg();
                int acctType = 0;//public
                List<VendorCloudPkgDdo> vendorPkgs = vendorCloudPkgCache.getVendorCloudPkgsByPkg(pkg.getId());
                if (CollectionUtils.isNullOrEmpty(vendorPkgs)) {
                    acctType = 1;//private
                }
                for (int j = 0; j < dto.getMfcCloudPkgDetails().size(); j++) {
                    MfcUserCloudDdo uc = new MfcUserCloudDdo();
                    MfcCloudPkgDetailDdo d = dto.getMfcCloudPkgDetails().get(j);
                    uc.setAccountId(accountId);
                    //uc.setAccountType(accountType);
                    uc.setCid(d.getCid());
                    uc.setExpiredTime(userCloudPkg.getExpiredTime());
                    uc.setAcctAlias(d.getAcctAlias());
                    uc.setAcctType(acctType);
                    ucs.add(uc);
                }
            }
        }
        if (userClouds != null) {
            ucs.addAll(userClouds);
        }

        Map<Long, List<MfcUserCloudDdo>> cloudMap = new HashMap<>();
        for (MfcUserCloudDdo uc : ucs) {
            List<MfcUserCloudDdo> clouds;
            if (cloudMap.containsKey(uc.getCid())) {
                clouds = cloudMap.get(uc.getCid());
            } else {
                clouds = new ArrayList<>();
                cloudMap.put(uc.getCid(), clouds);
            }
            clouds.add(uc);
        }
        for (Map.Entry<Long, List<MfcUserCloudDdo>> e : cloudMap.entrySet()) {
            if (e.getValue().size() <= 1) {
                continue;
            }
            e.getValue().sort((m1, m2) -> {
                long exp1 = m1.getExpiredTime() == null ? 0 : m1.getExpiredTime();
                long exp2 = m2.getExpiredTime() == null ? 0 : m2.getExpiredTime();
                if (exp1 == 0) {
                    exp1 = Long.MAX_VALUE;
                }
                if (exp2 == 0) {
                    exp2 = Long.MAX_VALUE;
                }

                if (exp1 > exp2) {
                    return -1;
                } else if (exp1 < exp2) {
                    return 1;
                } else {
                    String alias1 = m1.getAcctAlias() == null ? "" : m1.getAcctAlias();
                    String alias2 = m2.getAcctAlias() == null ? "" : m2.getAcctAlias();
                    return alias1.compareTo(alias2);
                }
            });
        }
        List<MfcUserCloudDdo> sortedClouds = new ArrayList<>();
        for (Map.Entry<Long, List<MfcUserCloudDdo>> e : cloudMap.entrySet()) {
            sortedClouds.add(e.getValue().get(0));
        }

        return sortedClouds;
    }


    private Map<String, List<MfcUserCloudDdo>> getAccountCloudsMap(List<MfcUserCloudDdo> userClouds) {
        Map<String, List<MfcUserCloudDdo>> accountMap = new HashMap<>();
        for (MfcUserCloudDdo uc : userClouds) {
            //String key = uc.getAccountId() + "_" + uc.getAccountType();
            String key = String.valueOf(uc.getAccountId());
            List<MfcUserCloudDdo> clouds;
            if (accountMap.containsKey(key)) {
                clouds = accountMap.get(key);
            } else {
                clouds = new ArrayList<>();
                accountMap.put(key, clouds);
            }
            clouds.add(uc);
        }
        return accountMap;
    }


    //获取网盘
    private List<MfcUserCloudDdo> getCloudByAccountByDb(long accountId) {
        try {
            //user_cloud
            List<MfcUserCloudDdo> userClouds = mfcUserCloudDao.getUserCloudsByAccount(accountId);
            if (userClouds == null) {
                userClouds = new ArrayList<>();
            }
            return userClouds;
        } catch (Exception ex) {
            logger.error("getCloudByAccountByDb(),exception.", ex);
            throw ex;
        }
    }


    //获取网盘包
    private List<MfcUserCloudPkgDdo> getCloudPkgByAccountByDb(long accountId) {
        try {
            List<MfcUserCloudPkgDdo> userClouds = mfcUserCloudDao.getUserCloudPkgsByAccount(accountId);
            if (userClouds == null) {
                userClouds = new ArrayList<>();
            }
            return userClouds;
        } catch (Exception ex) {
            logger.error("getCloudPkgByAccountByDb(),exception.", ex);
            throw ex;
        }
    }


    private Map<Long, MfcCloudPkgDto> getCloudPkgsByPkgIdByDb(Set<Long> pkgIds) {
        try {
            return cloudPkgCacheService.getCloudPkgsByPkgIds(pkgIds);
        } catch (Exception ex) {
            logger.error("getCloudPkgsByPkgIdByDb(),exception.", ex);
            throw ex;
        }
    }


}
