package com.valor.vod.cloud.model.database.ddo;


import com.valor.vod.common.database.model.AbstractLMI;

import javax.persistence.*;

//网盘包与用户的关联关系
@Entity
@Table(
    name = "mfc_user_cloud_migrate",indexes = {
    @Index(name = "i_mfc_user_cloud_migrate_dst_account_id",columnList = "dst_account_id"),
    @Index(name = "i_mfc_user_cloud_migrate_dst_account_type", columnList = "dst_account_type"),
    @Index(name = "i_mfc_user_cloud_migrate_src_account_id",columnList = "src_account_id"),
    @Index(name = "i_mfc_user_cloud_migrate_src_account_type", columnList = "src_account_type"),
    @Index(name = "i_mfc_user_cloud_migrate_type", columnList = "type")}
)
public class MfcUserCloudMigrateDdo extends AbstractLMI {

    @Id
    @Column(
        name = "dst_account_id"
    )
    private Long dstAccountId;

    @Id
    @Column(
        name = "dst_account_type"
    )
    private int dstAccountType ;

    //may be uid
    @Id
    @Column(
        name = "src_account_id"
    )
    private Long srcAccountId;

    @Id
    @Column(
        name = "src_account_type"
    )
    private int srcAccountType ;

    //0:migrate 1:list migrate
    @Id
    @Column(
        name = "type"
    )
    private int type ;


    @Column(
        name = "acct_count"
    )
    private int acctCount=0;

    @Column(
        name = "pkg_count"
    )
    private int pkgCount=0;

    @Column(
        name = "my_cloud_count"
    )
    private int myCloudCount=0;

    @Column(
        name = "share_cloud_count"
    )
    private int shareCloudCount=0;

    @Column(
        name = "shared_cloud_count"
    )
    private int sharedCloudCount=0;

    public Long getSrcAccountId() {
        return srcAccountId;
    }

    public void setSrcAccountId(Long srcAccountId) {
        this.srcAccountId = srcAccountId;
    }

    public int getSrcAccountType() {
        return srcAccountType;
    }

    public void setSrcAccountType(int srcAccountType) {
        this.srcAccountType = srcAccountType;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Long getDstAccountId() {
        return dstAccountId;
    }

    public void setDstAccountId(Long dstAccountId) {
        this.dstAccountId = dstAccountId;
    }

    public int getDstAccountType() {
        return dstAccountType;
    }

    public void setDstAccountType(int dstAccountType) {
        this.dstAccountType = dstAccountType;
    }

    public int getAcctCount() {
        return acctCount;
    }

    public void setAcctCount(int acctCount) {
        this.acctCount = acctCount;
    }

    public int getPkgCount() {
        return pkgCount;
    }

    public void setPkgCount(int pkgCount) {
        this.pkgCount = pkgCount;
    }


    public int getMyCloudCount() {
        return myCloudCount;
    }

    public void setMyCloudCount(int myCloudCount) {
        this.myCloudCount = myCloudCount;
    }

    public int getShareCloudCount() {
        return shareCloudCount;
    }

    public void setShareCloudCount(int shareCloudCount) {
        this.shareCloudCount = shareCloudCount;
    }


    public int getSharedCloudCount() {
        return sharedCloudCount;
    }

    public void setSharedCloudCount(int sharedCloudCount) {
        this.sharedCloudCount = sharedCloudCount;
    }
}
