package com.valor.vod.cloud.model.database.ddo;


import com.valor.vod.common.database.model.AbstractLMI;
import lombok.Data;

import javax.persistence.*;

@Entity
@Table(
    name = "my_cloud", indexes = {
    @Index(name = "i_my_cloud_account_id", columnList = "account_id")
    , @Index(name = "i_my_cloud_entity", columnList = "entity_id,entity_type")
}
)
@Data
public class MyCloudDdo extends AbstractLMI {
    /**
     * 账户id
     */
    @Id
    @Column(name = "account_id")
    private long accountId;

    //pkgid or cid
    @Id
    @Column(name = "entity_id")
    private long entityId;

    //0:cid 1:pkgid
    @Id
    @Column(name = "entity_type")
    private int entityType;

    @Column(
        name = "alias"
    )
    private String alias = "";

    @Column(name = "expired_time")
    private Long expiredTime = 0L;

    /**
     * 0:可以分享 1：不能分享
     */
    @Column(name = "share_flag")
    private int shareFlag = 0;
}
