package com.valor.vod.cloud.model.database.ddo;


import com.valor.vod.common.database.model.AbstractLMI;
import lombok.Data;

import javax.persistence.*;

@Entity
@Table(
    name = "share_cloud_group_user",indexes = {
        @Index(name = "i_scgu_from_account_id",columnList = "from_account_id")
        ,@Index(name = "i_scgu_to_account_id",columnList = "to_account_id")
        ,@Index(name = "i_scgu_group",columnList = "group_id,group_type")
        ,@Index(name = "i_scgu_share_id",columnList = "share_id")
        ,@Index(name = "i_scgu_share_group_d",columnList = "share_group_id")
    }
)
@Data
public class ShareCloudGroupUserDdo extends AbstractLMI {
    @Id
    @Column(name = "from_account_id")
    private long fromAccountId;
    @Id
    @Column(name = "to_account_id")
    private long toAccountId;
    @Id
    @Column(name = "group_id")
    private long groupId;
    @Id
    //0:vendorId
    @Column(name = "group_type")
    private int groupType;
    @Id
    @Column(name = "share_group_id")
    private long shareGroupId;

    //这个shareId可能在share_cloud中被删除掉了，但这里的记录不能删除
    //vendor展开一次后，如果用户把share记录删掉，也不能再次展开
    @Column(name = "share_id")
    private long shareId;


}
