/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.cloud.model.database.configuration;

import com.google.common.base.Strings;
import com.valor.vod.common.database.tool.configruation.AbstractDBCfgWithHikariCP;
import common.config.tools.config.ConfigAESTools;
import common.config.tools.config.ConfigTools3;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.transaction.PlatformTransactionManager;

public class MFCCloudDBConfiguration
extends AbstractDBCfgWithHikariCP {
    public static final String DATABASE_MODEL_BASE_PACKAGE = ConfigTools3.getString((String)"mfc.cloud.db.appendPackagesToScan", (String)"com.valor.vod.cloud.model.database.ddo");
    public static final List<String> DATABASE_MODEL_BASE_PACKAGE_LIST = ConfigTools3.getAsList((String)"mfc.cloud.db.appendPackagesToScan", (String)",");
    private static final Logger LOG = LoggerFactory.getLogger(MFCCloudDBConfiguration.class);
    private static String CRYPT_KEY = ConfigAESTools.getConfigAsString((String)"mfc.cloud.db.crypt.key", (String)"");
    private String host = this.getDBConfig("mfc.cloud.db.host", CRYPT_KEY);
    private String dbInst = this.getDBConfig("mfc.cloud.db.inst", CRYPT_KEY);
    private String username = this.getDBConfig("mfc.cloud.db.user", CRYPT_KEY);
    private String password = this.getDBConfig("mfc.cloud.db.pass", CRYPT_KEY);
    private String appendPackagesToScan = ConfigAESTools.getString((String)"mfc.cloud.db.appendPackagesToScan");
    private String dialect = ConfigTools3.getString((String)"db.dialect", (String)"org.hibernate.dialect.MySQL5Dialect");
    private String hbm2ddlAuto = ConfigTools3.getString((String)"db.hbm2ddlAuto", (String)"validate");
    private boolean showSql = ConfigTools3.getBoolean((String)"db.stat.showSql", (boolean)false);
    private boolean useL2Cache = ConfigTools3.getBoolean((String)"db.l2cache.useL2Cache", (boolean)false);
    private boolean useQueryCache = ConfigTools3.getBoolean((String)"db.l2cache.pool.useQueryCache", (boolean)false);
    private String l2CacheFactory = ConfigTools3.getString((String)"db.l2cache.l2CacheFactory", (String)"org.hibernate.cache.ehcache.EhCacheRegionFactory");
    private String mysqlURLExtend = ConfigTools3.getString((String)"mfc.db.mysql.url.extend", (String)"useUnicode=true&characterEncoding=utf8&autoReconnect=true&useSSL=false");

    private String getConnectUrl() {
        if (Strings.isNullOrEmpty((String)this.host) || Strings.isNullOrEmpty((String)this.dbInst) || Strings.isNullOrEmpty((String)this.username) || Strings.isNullOrEmpty((String)this.password)) {
            LOG.error("==host,dbInst,username,password ={}-{}-{}-{}", new Object[]{this.host, this.dbInst, this.username, this.password});
            throw new IllegalArgumentException("Invalid user db config");
        }
        return "jdbc:mysql://" + this.host + "/" + this.dbInst + "?" + this.mysqlURLExtend;
    }

    @Bean(destroyMethod="close", name={"cloudDataSource"})
    @Qualifier(value="cloudDataSource")
    public DataSource cloudDataSource() {
        LOG.info("Connect database:{}:{}:{}", new Object[]{this.host, this.dbInst, this.username});
        return this.getDataSource(this.getConnectUrl(), this.username, this.password);
    }

    @Bean(destroyMethod="destroy", name={"cloudSessionFactory"})
    @Qualifier(value="cloudSessionFactory")
    public FactoryBean<SessionFactory> userSessionFactory() {
        String[] scanedPackage = new String[DATABASE_MODEL_BASE_PACKAGE_LIST.size()];
        DATABASE_MODEL_BASE_PACKAGE_LIST.toArray(scanedPackage);
        if (Strings.isNullOrEmpty((String)this.appendPackagesToScan)) {
            return this.getSessionFactory(this.cloudDataSource(), this.appendPackagesToScan);
        }
        LOG.info("=== DATABASE_MODEL_BASE_PACKAGE_LIST == [{}]", (Object)scanedPackage.toString());
        return this.getSessionFactory(this.cloudDataSource(), scanedPackage);
    }

    @Bean(name={"cloudTransactionManager"})
    @Qualifier(value="cloudTransactionManager")
    public PlatformTransactionManager metaTransactionManager() throws Exception {
        return this.getTransactionManager((SessionFactory)this.userSessionFactory().getObject(), 1800);
    }

    public Properties getDBProperties() {
        Properties props = super.getDBProperties();
        this.useL2Cache = ConfigTools3.getBoolean((String)"db.l2cache.useL2Cache", (boolean)false);
        props.put("hibernate.dialect", this.dialect);
        props.put("hibernate.cache.use_second_level_cache", (Object)this.useL2Cache);
        props.put("hibernate.show_sql", (Object)this.showSql);
        if (this.useL2Cache) {
            props.put("hibernate.cache.region.factory_class", this.l2CacheFactory);
            props.put("hibernate.cache.use_query_cache", (Object)this.useQueryCache);
        }
        props.put("hibernate.hbm2ddl.auto", this.hbm2ddlAuto);
        LOG.info("===hibernate useL2Cache=[{}]/ hbm2ddlAuto=[{}]", (Object)this.useL2Cache, (Object)this.hbm2ddlAuto);
        return props;
    }

    public FactoryBean<SessionFactory> getSessionFactory(@Qualifier(value="cloudDataSource") DataSource dataSource, String ... scanPackages) {
        return super.getSessionFactory(dataSource, scanPackages);
    }

    public PlatformTransactionManager getTransactionManager(@Qualifier(value="cloudSessionFactory") SessionFactory sessionFactory, int txTimeout) throws Exception {
        return super.getTransactionManager(sessionFactory, txTimeout);
    }
}

