/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.cloud.model.database.dao;

import com.google.common.collect.Sets;
import com.valor.vod.cloud.model.database.dao.AbstractCloudBaseDao;
import com.valor.vod.cloud.model.database.ddo.Identifier;
import common.base.tools.stat.StatTools;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(value="cloudTransactionManager")
public class CloudBaseDao
extends AbstractCloudBaseDao {
    private static final Logger logger = LoggerFactory.getLogger(CloudBaseDao.class);
    @Autowired
    protected SessionFactory cloudSessionFactory;

    @Override
    @Transactional(value="cloudTransactionManager")
    public Session currentSession() {
        return this.cloudSessionFactory.getCurrentSession();
    }

    @Override
    @Transactional(value="cloudTransactionManager")
    public void storeEntity(Object entity) {
        super.storeEntity(entity);
    }

    @Override
    @Transactional(value="cloudTransactionManager")
    public void deleteEntity(Object entity) {
        this.currentSession().delete(entity);
    }

    @Override
    @Transactional(value="cloudTransactionManager")
    public void storeAllIfAbsent(Collection entities) {
        super.storeAllIfAbsent(entities);
    }

    public void storeAllNoRepeat(Collection entities) {
        if (entities != null && !entities.isEmpty()) {
            Session session = this.currentSession();
            for (Object entity : entities) {
                session.save(entity);
            }
        }
    }

    @Override
    @Transactional(value="cloudTransactionManager")
    public void deleteAll(Collection entities) {
        super.deleteAll(entities);
    }

    @Override
    @Transactional(value="cloudTransactionManager")
    public void storeAll(Collection entities) {
        super.storeAll(entities);
    }

    @Override
    @Transactional(value="cloudTransactionManager")
    public int executeUpdate(CharSequence queryCharSequence) {
        return super.executeUpdate(queryCharSequence);
    }

    @Override
    @Transactional(value="cloudTransactionManager")
    public int excuteSql(String sql) {
        return super.excuteSql(sql);
    }

    public List<Identifier> getIdentifier() {
        return this.currentSession().createCriteria(Identifier.class).list();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(value="cloudTransactionManager")
    public List getListData(boolean enableCahce, Class returnType, Map<String, Object> filters) {
        List var4;
        StatTools.startDBTimer((String)returnType.getSimpleName());
        try {
            var4 = super.getListData(enableCahce, returnType, filters);
        }
        finally {
            StatTools.stopDBTimer((String)returnType.getSimpleName());
        }
        return var4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(value="cloudTransactionManager")
    public Object getData(boolean enableCahce, Class returnType, Map<String, Object> filters) {
        Object var4;
        StatTools.startDBTimer((String)returnType.getSimpleName());
        try {
            var4 = super.getData(enableCahce, returnType, filters);
        }
        finally {
            StatTools.stopDBTimer((String)returnType.getSimpleName());
        }
        return var4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(value="cloudTransactionManager")
    public List getListDataIn(boolean enableCahce, Class returnType, Map<String, Object> filters) {
        List var4;
        try {
            StatTools.startDBTimer((String)returnType.getSimpleName());
            var4 = super.getListDataIn(enableCahce, returnType, filters);
        }
        finally {
            StatTools.stopDBTimer((String)returnType.getSimpleName());
        }
        return var4;
    }

    @Override
    @Transactional(value="cloudTransactionManager")
    public Set getSetData(boolean enableCahce, Class returnType, Map<String, Object> filters) {
        return new HashSet(this.getListData(enableCahce, returnType, filters));
    }

    public Set difference(Set set1, Set set2) {
        return Sets.difference((Set)set1, (Set)set2);
    }

    @Override
    public long criteriaQueryCount(Class valueType) {
        return super.criteriaQueryCount(valueType);
    }

    @Override
    public String getLatestUpdateTime(Class clazz, Map<String, Object> filters) {
        return super.getLatestUpdateTime(clazz, filters);
    }

    @Override
    public Date getLatestUpdateDate(Class clazz, Map<String, Object> filters) {
        return super.getLatestUpdateDate(clazz, filters);
    }
}

