package com.valor.vod.cloud.mfcusercloud;


import com.valor.vod.cloud.model.database.ddo.MfcUserCloudDdo;
import com.valor.vod.cloud.model.database.ddo.MfcUserCloudPkgDdo;
import com.valor.vod.cloud.model.database.dto.MfcCloudPkgDto;
import com.valor.vod.cloud.model.database.dto.MfcUserCloudPkgDto;

import java.util.*;

public interface MfcUserCloudService {
    //设置用户网盘关系
    void setUserCloud(MfcUserCloudDdo userCloud);

    //批量设置多个用户网盘关系
    void setUserClouds(List<MfcUserCloudDdo> userClouds);

    //批量设置单个用户网盘关系
    void setUserClouds(long accountId, List<MfcUserCloudDdo> userClouds);

    //删除用户网盘关系
    void delUserCloud(MfcUserCloudDdo userCloud);

    //批量删除多个用户网盘关系
    void delUserClouds(List<MfcUserCloudDdo> userClouds);

    //批量删除单个用户网盘关系记录
    void delUserClouds(long accountId, Set<Long> cids);

    //获取用户的网盘
    List<MfcUserCloudDdo> getUserCloudsByAccount(long accountId);

    //获取用户的网盘,同一个账号只会加一次同样的网盘
    Map<Long, MfcUserCloudDdo> getUserCloudsOfCidMapByAccount(long accountId);

    Map<Long, MfcUserCloudDdo> getMergedUserCloudsOfCidMapByAccount(long accountId);

    MfcUserCloudDdo getMergedUserCloudByAccountAndCid(long accountId, long cid);

    //获取用户的网盘包
    Map<Long, MfcCloudPkgDto> getCloudPkgsByAccount(long accountId);

    //获取用户的网盘包
    MfcCloudPkgDto getCloudPkgByAccountAndPkgId(long accountId, long pkgId);

    //获取网盘包
    //Map<Long,MfcCloudPkgDto> getCloudPkgsByPkgIds(Set<Long> pkgIds);
    //获取网盘包
    //MfcCloudPkgDto getCloudPkgBySecretKey(String secretKey);
    //获取合并后用户的网盘
    List<MfcUserCloudDdo> getMergedUserCloudsByAccount(long accountId);

    //获取用户网盘关系
    MfcUserCloudDdo getUserCloudsByAccountAndCid(long accountId, long cid);

    //获取用户网盘包关系
    MfcUserCloudPkgDdo getUserCloudPkgsByAccountAndPkgId(long accountId, long pkgId);

    //获取用户网盘包关系
    List<MfcUserCloudPkgDdo> getUserCloudPkgsByAccount(long accountId);

    Map<Long, MfcUserCloudPkgDdo> getUserCloudPkgsOfPkgIdMapByAccount(long accountId);

    Map<Long, MfcUserCloudPkgDto> getUserCloudPkgDtosByAccount(long accountId);

    //设置用户网盘包关系
    void setUserCloudPkg(MfcUserCloudPkgDdo userCloudPkg);

    void setUserCloudPkgs(long accountId, List<MfcUserCloudPkgDdo> userCloudPkgs);

    void setUserCloudPkgs(List<MfcUserCloudPkgDdo> userCloudPkgs);

    //删除用户网盘包关系
    void delUserCloudPkg(MfcUserCloudPkgDdo userCloudPkg);

    void delUserCloudPkgs(long accountId, Set<Long> pkgIds);

    void delUserCloudPkgs(List<MfcUserCloudPkgDdo> userCloudPkgs);

    MfcUserCloudDdo getUserCloudsByAccountAndCidAndAccType(long accountId, long cid, boolean onlyPrivate);

    //meta使用, 是否过滤黑名单网盘包与网盘
    Map<Long, UserCloudCidSummary> getCidSummaryByAccount(long accountId);

    void clearAccount(long accountId);

    void resetClouds(Set<Long> accountIds, List<MfcUserCloudDdo> mfcUserClouds, List<MfcUserCloudPkgDdo> mfcUserCloudPkgs, Map<Long, List<MfcUserCloudDdo>> newUserClouds, Map<Long, List<MfcUserCloudPkgDdo>> newUserCloudPkgs);
}
