package com.valor.vod.cloud.model.database.ddo;

import com.valor.vod.api.model.cloud.ECloudSite;
import com.valor.vod.common.database.model.AbstractLMI;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.util.Date;

/**
 * 网盘账户黑灰名单表
 * @author clovis
 * @date 2022/11/11
 */
@Getter
@Setter
@Entity
@Table(name = "cloud_acct_bg")
public class CloudAcctBgDdo extends AbstractLMI {
    /**
     * 网盘id
     * */
    @Id
    @Column(name = "cid")
    private Long cid;

    @Enumerated(EnumType.STRING)
    @Column(name = "site", length = 128)
    private ECloudSite site;

    /**
     * 账户id
     * */
    @Column(name = "login_id")
    private String loginId;

    /**
     * 0:黑名单/1:灰名单
     * */
    @Column(name = "type")
    private Integer type;

    /**
     * 状态 0启用/1停用
     * */
    @Column(name = "status")
    private Integer status;
}
