package com.valor.vod.cloud.model.database.ddo;


import com.valor.vod.common.database.model.AbstractLMI;

import javax.persistence.*;

//网盘包信息
@Entity
@Table(
    name = "mfc_cloud_pkg_export",indexes = {
    @Index(name = "i_mfc_cloud_pkg_export_name",columnList = "name"),
    @Index(name = "i_mfc_cloud_pkg_export_secret_key", columnList = "secret_key")
    }
)
public class MfcCloudPkgExportDdo extends TenantAbstractLMI {

    @Id
    @Column(name = "id")
    private long id = 0;//资源包ID

    /**
     * 网盘包名称
     * */
    @Column(name = "name")
    private String name;

    @Column(name = "description")
    private String description;
    /**
     * 网盘包所有者名称
     * */
    @Column(name = "author")
    private String author;
    /**
     * 网盘包zip文件密码
     * */
    @Column(name = "password")
    private String password;

    @Column(name = "expire_date")
    private long expireDate;

    @Column(name = "service_period")
    private int servicePeriod = 0;//使用时长，默认长期

    @Column(name = "service_period_unit")
    private int servicePeriodUnit = 3;//使用单位，默认月 , 1:day,2:week,3:month,4:year

    /**
     * 授权信息
     * */
    @Column(name = "authorizations")
    private String authorizations;

    //用于编辑包
    @Column(name = "secret_key",unique = true)
    private String secretKey;
    //原始包名
    @Column(name = "file_name")
    private String fileName;

    @Column(name = "remote_path")
    private String remotePath;

    @Column(name = "short_url")
    private String shortUrl;

    @Column(name = "pkg_protected")
    private int pkgProtected = 0;

    @Column(name = "owner_account_id")
    private long ownerAccountId = 0;

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public long getExpireDate() {
        return expireDate;
    }

    public void setExpireDate(long expireDate) {
        this.expireDate = expireDate;
    }

    public int getServicePeriod() {
        return servicePeriod;
    }

    public void setServicePeriod(int servicePeriod) {
        this.servicePeriod = servicePeriod;
    }

    public int getServicePeriodUnit() {
        return servicePeriodUnit;
    }

    public void setServicePeriodUnit(int servicePeriodUnit) {
        this.servicePeriodUnit = servicePeriodUnit;
    }

    public String getAuthorizations() {
        return authorizations;
    }

    public void setAuthorizations(String authorizations) {
        this.authorizations = authorizations;
    }

    public String getSecretKey() {
        return secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }


    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getRemotePath() {
        return remotePath;
    }

    public void setRemotePath(String remotePath) {
        this.remotePath = remotePath;
    }

    public String getShortUrl() {
        return shortUrl;
    }

    public void setShortUrl(String shortUrl) {
        this.shortUrl = shortUrl;
    }


    public int getPkgProtected() {
        return pkgProtected;
    }

    public void setPkgProtected(int pkgProtected) {
        this.pkgProtected = pkgProtected;
    }


    public long getOwnerAccountId() {
        return ownerAccountId;
    }

    public void setOwnerAccountId(long ownerAccountId) {
        this.ownerAccountId = ownerAccountId;
    }
}
