package com.valor.vod.cloud.model.database.ddo;


import com.valor.vod.common.database.model.AbstractLMI;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;

@Entity
@Table(
    name = "share_cloud", indexes = {
    @Index(name = "i_share_cloud_from_account_id", columnList = "from_account_id")
    , @Index(name = "i_share_cloud_to_account_id", columnList = "to_account_id")
}
)
@Getter
@Setter
public class ShareCloudDdo extends TenantAbstractLMI {
    /**
     * 自增id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id")
    private long id;

    @Column(name = "from_account_id")
    private long fromAccountId;

    @Column(name = "to_account_id")
    private long toAccountId;

    @Column(name = "from_nick_name")
    private String fromNickName;

    @Column(name = "to_user_type")
    private int toUserType;

    @Column(name = "to_user_id")
    private String toUserId;

    @Column(name = "to_nick_name")
    private String toNickName;

    //0:init;1:accept;2:reject
    @Column(name = "accept_flag")
    private int acceptFlag;

    //0:user share 1: share to 2: share to vendor 3 import 4:autoAdd
    @Column(name = "share_type")
    private int shareType;

    /**
     * 网盘包名称
     */
    @Column(name = "cloud_name")
    private String cloudName;

    /**
     * 是否激活状态，默认未激活0
     */
    @Column(name = "active_status")
    private Integer activeStatus = 0;

    @Column(name = "accept_time")
    private Long acceptTime;

    @Column(
        name = "expired_start_time"
    )
    private Long expiredStartTime;

    @Column(name = "expired_period")
    private Long expiredPeriod = 0L;

    @Column(name = "service_period")
    private Integer servicePeriod = 0;

    /**
     * 使用单位，默认月  1:day,2:week,3:month,4:year
     */
    @Column(name = "service_period_unit")
    private int servicePeriodUnit = 3;

    //从哪个ID合入的
    @Column(name = "src_share_id")
    private long srcShareId;

    //从哪个Vendor合入的
    @Column(name = "src_vendor_id")
    private long srcVendorId;
}
