package com.valor.vod.cloud.model.database.ddo;


import com.valor.vod.common.database.model.AbstractLMI;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;

@Entity
@Table(
    name = "share_cloud_group",indexes = {
    @Index(name = "i_scg_from_account_id",columnList = "from_account_id")
    ,@Index(name = "i_scg_to_group",columnList = "to_group_id,to_group_type")
    }
)
@Getter
@Setter
public class ShareCloudGroupDdo extends TenantAbstractLMI {

    @Id
    @Column(name = "id")
    private long id;

    @Column(name = "from_account_id")
    private long fromAccountId;

    @Column(name = "from_nick_name")
    private String fromNickName;

    @Column(name = "cloud_name")
    private String cloudName;

    @Column(name = "to_group_id")
    private long toGroupId;

    //0:vendorId
    @Column(name = "to_group_type")
    private int toGroupType;

    @Column(
        name = "expired_start_time"
    )
    private long expiredStartTime=0L;

    @Column(
        name = "expired_period"
    )
    private long expiredPeriod=0L;

    @Column(name = "service_period")
    private int servicePeriod = 0;

    /**
     * 使用单位，默认月 , 1:day,2:week,3:month,4:year
     */
    @Column(name = "service_period_unit")
    private int servicePeriodUnit = 3;
}
