package com.valor.vod.cloud.model.database.ddo;

import com.valor.vod.common.database.model.AbstractLMI;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;

@Entity
@Table(
    name = "user_cloud",indexes = {
    @Index(name = "i_user_cloud_account_id",columnList = "account_id"),
    @Index(name = "i_user_cloud_cid", columnList = "cid")}
)
@Getter
@Setter
public class UserCloudDdo extends AbstractLMI {

    @Id
    @Column(
        name = "account_id"
    )
    private Long accountId;

    @Id
    @Column(
        name = "cid"
    )
    private Long cid;


    @Column(
        name = "acct_type"
    )
    private int acctType;

    @Column(
        name = "acct_alias",
        length = 128
    )
    private String acctAlias = "";


    @Column(
        name = "pkg_id"
    )
    private Long pkgId;


    @Column(
        name = "expired_time"
    )
    private Long expiredTime=0L;
}
