package com.valor.vod.cloud.model.database.ddo;

import com.valor.vod.common.database.model.AbstractLMI;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;

@Entity
@Table(
    name = "user_public_cloud",
    indexes = {@Index(
        name = "user_public_cloud_account_id",
        columnList = "account_id"
    )}
)
@Getter
@Setter
public class UserPublicCloudDdo extends AbstractLMI {

    @Id
    @Column(
        name = "account_id"
    )
    private Long accountId;

    @Column(
        name = "public_cids_1",
        columnDefinition = "bigint default 0"
    )
    private long publicCids1 = 0;


    @Column(
        name = "public_cids_2",
        columnDefinition = "bigint default 0"
    )
    private long publicCids2 = 0;


    @Column(
        name = "public_cids_3",
        columnDefinition = "bigint default 0"
    )
    private long publicCids3 = 0;


    @Column(
        name = "public_cids_4",
        columnDefinition = "bigint default 0"
    )
    private long publicCids4 = 0;

    @Column(
        name = "public_cids_5",
        columnDefinition = "bigint default 0"
    )
    private long publicCids5 = 0;
}
