/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.cloud.blackGrey;

import com.valor.vod.cloud.model.database.dao.CloudBaseDao;
import com.valor.vod.cloud.model.database.ddo.CloudPkgBgDdo;
import common.base.tools.type.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(value="cloudTransactionManager")
public class CloudPkgBgDao
extends CloudBaseDao {
    @Autowired
    protected SessionFactory cloudSessionFactory;

    @Override
    @Transactional(value="cloudTransactionManager")
    public Session currentSession() {
        return this.cloudSessionFactory.getCurrentSession();
    }

    public long count(String pkgId, Integer type) {
        Criteria criteria = this.currentSession().createCriteria(CloudPkgBgDdo.class);
        if (StringUtils.isNotBlank((String)pkgId)) {
            criteria.add((Criterion)Restrictions.eq((String)"pkgId", (Object)Long.parseLong(pkgId)));
        }
        if (type != null) {
            criteria.add((Criterion)Restrictions.eq((String)"type", (Object)type));
        }
        criteria.setProjection(Projections.rowCount());
        return (Long)criteria.uniqueResult();
    }

    @Transactional(value="cloudTransactionManager")
    public List<CloudPkgBgDdo> list(String pkgId, Integer type, int start, int size) {
        Criteria criteria = this.currentSession().createCriteria(CloudPkgBgDdo.class);
        if (StringUtils.isNotBlank((String)pkgId)) {
            criteria.add((Criterion)Restrictions.eq((String)"pkgId", (Object)Long.parseLong(pkgId)));
        }
        if (type != null) {
            criteria.add((Criterion)Restrictions.eq((String)"type", (Object)type));
        }
        criteria.setFirstResult(start);
        criteria.setMaxResults(size);
        List results = criteria.list();
        if (CollectionUtils.isNullOrEmpty((Collection)results)) {
            return new ArrayList<CloudPkgBgDdo>();
        }
        return results;
    }

    @Transactional(value="cloudTransactionManager")
    public List<CloudPkgBgDdo> queryList(List<Long> pkgIds) {
        Criteria criteria = this.currentSession().createCriteria(CloudPkgBgDdo.class);
        criteria.add(Restrictions.in((String)"pkgId", pkgIds));
        List results = criteria.list();
        if (CollectionUtils.isNullOrEmpty((Collection)results)) {
            return new ArrayList<CloudPkgBgDdo>();
        }
        return results;
    }

    public List<Long> queryBlackList(Set<Long> pkgIds) {
        if (CollectionUtils.isNullOrEmpty(pkgIds)) {
            return new ArrayList<Long>();
        }
        Criteria criteria = this.currentSession().createCriteria(CloudPkgBgDdo.class);
        criteria.add(Restrictions.in((String)"pkgId", pkgIds));
        criteria.add((Criterion)Restrictions.eq((String)"type", (Object)0));
        criteria.add((Criterion)Restrictions.eq((String)"status", (Object)0));
        List results = criteria.list();
        if (CollectionUtils.isNullOrEmpty((Collection)results)) {
            return new ArrayList<Long>();
        }
        return results.stream().map(CloudPkgBgDdo::getPkgId).collect(Collectors.toList());
    }

    public List<CloudPkgBgDdo> queryValidList(List<Long> pkgIds) {
        if (CollectionUtils.isNullOrEmpty(pkgIds)) {
            return new ArrayList<CloudPkgBgDdo>();
        }
        Criteria criteria = this.currentSession().createCriteria(CloudPkgBgDdo.class);
        criteria.add(Restrictions.in((String)"pkgId", pkgIds));
        criteria.add((Criterion)Restrictions.eq((String)"status", (Object)0));
        List results = criteria.list();
        if (CollectionUtils.isNullOrEmpty((Collection)results)) {
            return new ArrayList<CloudPkgBgDdo>();
        }
        return results;
    }
}

