/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.cloud.mfcusercloud;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaCache {
    private static final Logger logger = LoggerFactory.getLogger(GuavaCache.class);
    private static ScheduledExecutorService clearExecutor = Executors.newScheduledThreadPool(8);
    Cache<String, Object> guavaCache = null;
    private long statSeconds = 300L;
    private long metricSeconds = 60L;
    private String cacheName;
    private Long maximumSize = 0L;

    public GuavaCache(String cacheName, long expireSeconds, long maximumSize) {
        this.cacheName = cacheName;
        this.maximumSize = maximumSize;
        this.guavaCache = maximumSize == 0L ? CacheBuilder.newBuilder().recordStats().expireAfterWrite(expireSeconds, TimeUnit.SECONDS).build() : CacheBuilder.newBuilder().recordStats().expireAfterWrite(expireSeconds, TimeUnit.SECONDS).maximumSize(maximumSize).build();
        clearExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    GuavaCache.this.guavaCache.cleanUp();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, 0L, 4L, TimeUnit.HOURS);
    }

    public void del(String key) {
        try {
            this.guavaCache.invalidate((Object)key);
        }
        catch (Exception ex) {
            logger.error("del(),exception:{}", (Throwable)ex);
        }
    }

    public Boolean exists(String key) {
        try {
            return this.guavaCache.asMap().containsKey(key);
        }
        catch (Exception ex) {
            logger.error("del(),exception:{}", (Throwable)ex);
            return null;
        }
    }

    public <V> V get(String key) {
        try {
            Optional optObj = (Optional)this.guavaCache.getIfPresent((Object)key);
            if (optObj == null) {
                return null;
            }
            if (optObj.isPresent()) {
                return (V)optObj.get();
            }
            return null;
        }
        catch (Exception ex) {
            logger.error("get(),exception:{}", (Throwable)ex);
            return null;
        }
    }

    public <V> void set(String key, V value) {
        try {
            Optional<V> optValue = Optional.ofNullable(value);
            this.guavaCache.put((Object)key, optValue);
        }
        catch (Exception ex) {
            logger.error("set(),exception:{}", (Throwable)ex);
        }
    }

    public <V> List<V> mGet(String[] keys) {
        try {
            ArrayList<Object> results = new ArrayList<Object>();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                Optional optObj = (Optional)this.guavaCache.getIfPresent((Object)key);
                Object obj = null;
                obj = optObj == null ? null : (optObj.isPresent() ? (Object)optObj.get() : null);
                results.add(obj);
            }
            return results;
        }
        catch (Exception ex) {
            logger.error("mGet(),exception:{}", (Throwable)ex);
            return null;
        }
    }

    public <V> void mSet(Map<String, V> keyValueMap) {
        try {
            for (Map.Entry<String, V> e : keyValueMap.entrySet()) {
                Optional<V> optValue = Optional.ofNullable(e.getValue());
                this.guavaCache.put((Object)e.getKey(), optValue);
            }
        }
        catch (Exception ex) {
            logger.error("mSet(),exception:{}", (Throwable)ex);
        }
    }

    public Set<String> keys() {
        try {
            return this.guavaCache.asMap().keySet();
        }
        catch (Exception ex) {
            logger.error("keys(),exception:{}", (Throwable)ex);
            return null;
        }
    }
}

