/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.cloud.mfcusercloud;

import com.valor.vod.cloud.model.database.dao.CloudBaseDao;
import com.valor.vod.cloud.model.database.ddo.MfcCloudPkgDdo;
import com.valor.vod.cloud.model.database.ddo.MfcCloudPkgDetailDdo;
import com.valor.vod.cloud.model.database.ddo.MfcCloudPkgDetailExportDdo;
import com.valor.vod.cloud.model.database.ddo.MfcCloudPkgExportDdo;
import com.valor.vod.cloud.model.database.ddo.MfcUserCloudDdo;
import com.valor.vod.cloud.model.database.ddo.MfcUserCloudMigrateDdo;
import com.valor.vod.cloud.model.database.ddo.MfcUserCloudPkgDdo;
import com.valor.vod.cloud.model.database.ddo.MfcUserCloudPkgHistoryDdo;
import com.valor.vod.cloud.model.database.ddo.VendorCloudPkgDdo;
import common.base.tools.type.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(value="cloudTransactionManager")
public class MfcUserCloudDao
extends CloudBaseDao {
    private static final Logger logger = LoggerFactory.getLogger(MfcUserCloudDao.class);

    public Map<Long, MfcUserCloudDdo> getUserCloudsByAccountAndCids(long accountId, Set<Long> cids) {
        HashMap<Long, MfcUserCloudDdo> map = new HashMap<Long, MfcUserCloudDdo>();
        if (CollectionUtils.isNullOrEmpty(cids)) {
            return map;
        }
        Criteria criteria = this.currentSession().createCriteria(MfcUserCloudDdo.class);
        criteria.add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId));
        criteria.add(Restrictions.in((String)"cid", cids));
        List ucs = criteria.list();
        if (ucs == null) {
            return map;
        }
        for (int i = 0; i < ucs.size(); ++i) {
            MfcUserCloudDdo uc = (MfcUserCloudDdo)((Object)ucs.get(i));
            map.put(uc.getCid(), uc);
        }
        return map;
    }

    public List<MfcUserCloudDdo> getUserCloudsByAccount(long accountId) {
        Criteria criteria = this.currentSession().createCriteria(MfcUserCloudDdo.class);
        criteria.add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId));
        List ucs = criteria.list();
        if (ucs == null) {
            return new ArrayList<MfcUserCloudDdo>();
        }
        return ucs;
    }

    public List<MfcUserCloudDdo> getUserCloudsByAccounts(Set<Long> accountIds) {
        Criteria criteria = this.currentSession().createCriteria(MfcUserCloudDdo.class);
        criteria.add(Restrictions.in((String)"accountId", accountIds));
        List ucs = criteria.list();
        if (ucs == null) {
            return new ArrayList<MfcUserCloudDdo>();
        }
        return ucs;
    }

    public MfcUserCloudMigrateDdo getUserCloudMigrateByAccount(long srcAccountId, int srcAccountType, long dstAccountId, int dstAccountType, int type) {
        Criteria criteria = this.currentSession().createCriteria(MfcUserCloudMigrateDdo.class);
        criteria.add((Criterion)Restrictions.eq((String)"srcAccountId", (Object)srcAccountId));
        criteria.add((Criterion)Restrictions.eq((String)"srcAccountType", (Object)srcAccountType));
        criteria.add((Criterion)Restrictions.eq((String)"dstAccountId", (Object)dstAccountId));
        criteria.add((Criterion)Restrictions.eq((String)"dstAccountType", (Object)dstAccountType));
        criteria.add((Criterion)Restrictions.eq((String)"type", (Object)type));
        List ucs = criteria.list();
        if (CollectionUtils.isNullOrEmpty((Collection)ucs)) {
            return null;
        }
        return (MfcUserCloudMigrateDdo)((Object)ucs.get(0));
    }

    public List<MfcUserCloudPkgDdo> getUserCloudPkgsByAccount(long accountId) {
        Criteria criteria = this.currentSession().createCriteria(MfcUserCloudPkgDdo.class);
        criteria.add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId));
        List ucs = criteria.list();
        if (ucs == null) {
            return new ArrayList<MfcUserCloudPkgDdo>();
        }
        return ucs;
    }

    public List<MfcUserCloudPkgDdo> getUserCloudPkgsByAccounts(Set<Long> accountIds) {
        Criteria criteria = this.currentSession().createCriteria(MfcUserCloudPkgDdo.class);
        criteria.add(Restrictions.in((String)"accountId", accountIds));
        List ucs = criteria.list();
        if (ucs == null) {
            return new ArrayList<MfcUserCloudPkgDdo>();
        }
        return ucs;
    }

    public MfcCloudPkgDdo getCloudPkg(long pkgId) {
        Criteria criteria = this.currentSession().createCriteria(MfcCloudPkgDdo.class);
        criteria.add(Restrictions.in((String)"id", (Object[])new Object[]{pkgId}));
        List ucs = criteria.list();
        if (CollectionUtils.isNullOrEmpty((Collection)ucs)) {
            return null;
        }
        return (MfcCloudPkgDdo)((Object)ucs.get(0));
    }

    public List<MfcCloudPkgDetailDdo> getCloudPkgDetails(long pkgId) {
        Criteria criteria = this.currentSession().createCriteria(MfcCloudPkgDetailDdo.class);
        criteria.add((Criterion)Restrictions.eq((String)"pkgId", (Object)pkgId));
        List ucs = criteria.list();
        if (ucs == null) {
            return new ArrayList<MfcCloudPkgDetailDdo>();
        }
        return ucs;
    }

    public List<MfcCloudPkgDdo> getCloudPkgs(Set<Long> pkgIds) {
        Criteria criteria = this.currentSession().createCriteria(MfcCloudPkgDdo.class);
        criteria.add(Restrictions.in((String)"id", pkgIds));
        List ucs = criteria.list();
        if (ucs == null) {
            return new ArrayList<MfcCloudPkgDdo>();
        }
        return ucs;
    }

    public MfcCloudPkgDdo getCloudPkgByName(String pkgName) {
        Criteria criteria = this.currentSession().createCriteria(MfcCloudPkgDdo.class);
        criteria.add(Restrictions.in((String)"name", (Object[])new Object[]{pkgName}));
        List ucs = criteria.list();
        if (CollectionUtils.isNullOrEmpty((Collection)ucs)) {
            return null;
        }
        return (MfcCloudPkgDdo)((Object)ucs.get(0));
    }

    public List<MfcCloudPkgDetailDdo> getCloudPkgDetails(Set<Long> pkgIds) {
        if (CollectionUtils.isNullOrEmpty(pkgIds)) {
            return new ArrayList<MfcCloudPkgDetailDdo>();
        }
        Criteria criteria = this.currentSession().createCriteria(MfcCloudPkgDetailDdo.class);
        criteria.add(Restrictions.in((String)"pkgId", pkgIds));
        List ucs = criteria.list();
        if (ucs == null) {
            return new ArrayList<MfcCloudPkgDetailDdo>();
        }
        return ucs;
    }

    public Map<Long, MfcUserCloudPkgHistoryDdo> getUserCloudPkgHistoriesByAccountAndPkgIds(long accountId, Set<Long> pkgIds) {
        HashMap<Long, MfcUserCloudPkgHistoryDdo> map = new HashMap<Long, MfcUserCloudPkgHistoryDdo>();
        if (pkgIds == null) {
            return map;
        }
        Criteria criteria = this.currentSession().createCriteria(MfcUserCloudPkgHistoryDdo.class);
        criteria.add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId));
        criteria.add(Restrictions.in((String)"pkgId", pkgIds));
        List ucs = criteria.list();
        if (ucs == null) {
            return map;
        }
        for (int i = 0; i < ucs.size(); ++i) {
            MfcUserCloudPkgHistoryDdo uc = (MfcUserCloudPkgHistoryDdo)((Object)ucs.get(i));
            map.put(uc.getPkgId(), uc);
        }
        return map;
    }

    public MfcUserCloudPkgHistoryDdo getUserCloudPkgHistoriesByAccountAndPkgId(long accountId, long pkgId) {
        Criteria criteria = this.currentSession().createCriteria(MfcUserCloudPkgHistoryDdo.class);
        criteria.add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId));
        criteria.add((Criterion)Restrictions.eq((String)"pkgId", (Object)pkgId));
        List ucs = criteria.list();
        if (CollectionUtils.isNullOrEmpty((Collection)ucs)) {
            return null;
        }
        return (MfcUserCloudPkgHistoryDdo)((Object)ucs.get(0));
    }

    public Map<Long, MfcUserCloudPkgDdo> getUserCloudPkgsByAccountAndPkgIds(long accountId, Set<Long> pkgIds) {
        HashMap<Long, MfcUserCloudPkgDdo> map = new HashMap<Long, MfcUserCloudPkgDdo>();
        if (CollectionUtils.isNullOrEmpty(pkgIds)) {
            return map;
        }
        Criteria criteria = this.currentSession().createCriteria(MfcUserCloudPkgDdo.class);
        criteria.add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId));
        criteria.add(Restrictions.in((String)"pkgId", pkgIds));
        List ucs = criteria.list();
        if (ucs == null) {
            return map;
        }
        for (int i = 0; i < ucs.size(); ++i) {
            MfcUserCloudPkgDdo uc = (MfcUserCloudPkgDdo)((Object)ucs.get(i));
            map.put(uc.getPkgId(), uc);
        }
        return map;
    }

    public MfcCloudPkgExportDdo getCloudPkgExportByPkgId(long pkgId) {
        Criteria criteria = this.currentSession().createCriteria(MfcCloudPkgExportDdo.class);
        criteria.add((Criterion)Restrictions.eq((String)"id", (Object)pkgId));
        List pkgs = criteria.list();
        if (CollectionUtils.isNullOrEmpty((Collection)pkgs)) {
            return null;
        }
        return (MfcCloudPkgExportDdo)((Object)pkgs.get(0));
    }

    public List<MfcCloudPkgExportDdo> getCloudPkgExportByPkgIds(Set<Long> pkgIds) {
        Criteria criteria = this.currentSession().createCriteria(MfcCloudPkgExportDdo.class);
        criteria.add(Restrictions.in((String)"id", pkgIds));
        List pkgs = criteria.list();
        if (CollectionUtils.isNullOrEmpty((Collection)pkgs)) {
            return new ArrayList<MfcCloudPkgExportDdo>();
        }
        return pkgs;
    }

    public MfcCloudPkgExportDdo getCloudPkgExportBySecretKey(String secretKey) {
        Criteria criteria = this.currentSession().createCriteria(MfcCloudPkgExportDdo.class);
        criteria.add((Criterion)Restrictions.eq((String)"secretKey", (Object)secretKey));
        List pkgs = criteria.list();
        if (CollectionUtils.isNullOrEmpty((Collection)pkgs)) {
            return null;
        }
        return (MfcCloudPkgExportDdo)((Object)pkgs.get(0));
    }

    public List<MfcCloudPkgDetailExportDdo> getCloudPkgDetailExportsByPkgId(long pkgId) {
        Criteria criteria = this.currentSession().createCriteria(MfcCloudPkgDetailExportDdo.class);
        criteria.add((Criterion)Restrictions.eq((String)"pkgId", (Object)pkgId));
        List details = criteria.list();
        if (CollectionUtils.isNullOrEmpty((Collection)details)) {
            return new ArrayList<MfcCloudPkgDetailExportDdo>();
        }
        return details;
    }

    public List<MfcCloudPkgDetailExportDdo> getValidCloudPkgDetailExport(long pkgId) {
        Criteria criteria = this.currentSession().createCriteria(MfcCloudPkgDetailExportDdo.class);
        criteria.add((Criterion)Restrictions.eq((String)"pkgId", (Object)pkgId));
        criteria.add((Criterion)Restrictions.eq((String)"cid", (Object)-1L));
        List details = criteria.list();
        if (CollectionUtils.isNullOrEmpty((Collection)details)) {
            return new ArrayList<MfcCloudPkgDetailExportDdo>();
        }
        return details;
    }

    public MfcCloudPkgDetailDdo getValidCloudPkgDetail(long pkgId, String site, String name) {
        Criteria criteria = this.currentSession().createCriteria(MfcCloudPkgDetailDdo.class);
        criteria.add((Criterion)Restrictions.eq((String)"pkgId", (Object)pkgId));
        criteria.add((Criterion)Restrictions.eq((String)"acctSite", (Object)site));
        criteria.add((Criterion)Restrictions.eq((String)"acctUserName", (Object)name));
        criteria.add((Criterion)Restrictions.eq((String)"cid", (Object)-1L));
        List details = criteria.list();
        if (CollectionUtils.isNullOrEmpty((Collection)details)) {
            return null;
        }
        return (MfcCloudPkgDetailDdo)((Object)details.get(0));
    }

    public List<MfcCloudPkgDetailExportDdo> getCloudPkgDetailExportsByPkgIds(Set<Long> pkgIds) {
        Criteria criteria = this.currentSession().createCriteria(MfcCloudPkgDetailExportDdo.class);
        criteria.add(Restrictions.in((String)"pkgId", pkgIds));
        List details = criteria.list();
        if (CollectionUtils.isNullOrEmpty((Collection)details)) {
            return new ArrayList<MfcCloudPkgDetailExportDdo>();
        }
        return details;
    }

    public List<VendorCloudPkgDdo> loadVendorCloudPkgs() {
        Criteria criteria = this.currentSession().createCriteria(VendorCloudPkgDdo.class);
        ArrayList pkgs = criteria.list();
        if (pkgs == null) {
            pkgs = new ArrayList();
        }
        return pkgs;
    }

    public VendorCloudPkgDdo getVendorCloudPkgByVendorIdAndPkgId(long vendorId, long pkgId) {
        Criteria criteria = this.currentSession().createCriteria(VendorCloudPkgDdo.class);
        criteria.add((Criterion)Restrictions.eq((String)"vendorId", (Object)vendorId));
        criteria.add((Criterion)Restrictions.eq((String)"pkgId", (Object)pkgId));
        List pkgs = criteria.list();
        if (CollectionUtils.isNullOrEmpty((Collection)pkgs)) {
            return null;
        }
        return (VendorCloudPkgDdo)((Object)pkgs.get(0));
    }

    public List<VendorCloudPkgDdo> getVendorCloudPkgsByPkgId(long pkgId) {
        Criteria criteria = this.currentSession().createCriteria(VendorCloudPkgDdo.class);
        criteria.add((Criterion)Restrictions.eq((String)"pkgId", (Object)pkgId));
        List pkgs = criteria.list();
        if (CollectionUtils.isNullOrEmpty((Collection)pkgs)) {
            return new ArrayList<VendorCloudPkgDdo>();
        }
        return pkgs;
    }
}

