/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.cloud.mfcusercloud;

import com.valor.vod.api.common.ListTool;
import com.valor.vod.api.common.MapTool;
import com.valor.vod.api.common.SetTool;
import com.valor.vod.api.model.cloud.ECloudAcctType;
import com.valor.vod.cloud.blackGrey.CloudAcctBgDao;
import com.valor.vod.cloud.blackGrey.CloudPkgBgDao;
import com.valor.vod.cloud.cache.CloudRedisCache;
import com.valor.vod.cloud.mfcusercloud.CidSummaryService;
import com.valor.vod.cloud.mfcusercloud.CloudPkgCacheService;
import com.valor.vod.cloud.mfcusercloud.MfcUserCloudDao;
import com.valor.vod.cloud.mfcusercloud.MfcUserCloudService;
import com.valor.vod.cloud.mfcusercloud.RefreshAccountEntity;
import com.valor.vod.cloud.mfcusercloud.UserCloudCidSummary;
import com.valor.vod.cloud.mfcusercloud.VendorCloudPkgCache;
import com.valor.vod.cloud.model.database.ddo.MfcCloudPkgDdo;
import com.valor.vod.cloud.model.database.ddo.MfcCloudPkgDetailDdo;
import com.valor.vod.cloud.model.database.ddo.MfcUserCloudDdo;
import com.valor.vod.cloud.model.database.ddo.MfcUserCloudPkgDdo;
import com.valor.vod.cloud.model.database.ddo.TenantAbstractLMI;
import com.valor.vod.cloud.model.database.ddo.VendorCloudPkgDdo;
import com.valor.vod.cloud.model.database.dto.MfcCloudPkgDto;
import com.valor.vod.cloud.model.database.dto.MfcUserCloudPkgDto;
import com.valor.vod.common.tools.type.CollectionUtils;
import common.config.tools.config.ConfigTools3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="mfcUserCloudService")
public class MfcUserCloudServiceImpl
implements MfcUserCloudService {
    private static final Logger logger = LoggerFactory.getLogger(MfcUserCloudServiceImpl.class);
    @Autowired
    VendorCloudPkgCache vendorCloudPkgCache;
    @Autowired
    MfcUserCloudDao mfcUserCloudDao;
    @Autowired
    CloudRedisCache cloudRedisCache;
    @Autowired
    CloudPkgCacheService cloudPkgCacheService;
    @Autowired
    CidSummaryService cidSummaryService;
    @Autowired
    CloudAcctBgDao cloudAcctBgDao;
    @Autowired
    CloudPkgBgDao cloudPkgBgDao;

    @Override
    public void setUserCloud(MfcUserCloudDdo userCloud) {
        this.setUserClouds(userCloud.getAccountId(), ListTool.toList((Object[])new MfcUserCloudDdo[]{userCloud}));
    }

    @Override
    public void setUserClouds(List<MfcUserCloudDdo> userClouds) {
        Map<String, List<MfcUserCloudDdo>> accountMap = this.getAccountCloudsMap(userClouds);
        for (Map.Entry<String, List<MfcUserCloudDdo>> e : accountMap.entrySet()) {
            long accountId = Long.parseLong(e.getKey());
            this.setUserClouds(accountId, e.getValue());
        }
    }

    @Override
    public void setUserClouds(long accountId, List<MfcUserCloudDdo> userClouds) {
        if (CollectionUtils.isNullOrEmpty(userClouds)) {
            return;
        }
        ArrayList<MfcUserCloudDdo> ucDdos = new ArrayList<MfcUserCloudDdo>();
        Set<Long> cids = userClouds.stream().map(MfcUserCloudDdo::getCid).collect(Collectors.toSet());
        Map<Long, MfcUserCloudDdo> ucMap = this.mfcUserCloudDao.getUserCloudsByAccountAndCids(accountId, cids);
        for (MfcUserCloudDdo uc : userClouds) {
            MfcUserCloudDdo ucDdo = (MfcUserCloudDdo)((Object)MapTool.get(ucMap, (Object)uc.getCid()));
            if (ucDdo == null) {
                ucDdo = new MfcUserCloudDdo();
            }
            ucDdo.setAccountId(accountId);
            ucDdo.setAcctAlias(uc.getAcctAlias());
            ucDdo.setAcctType(uc.getAcctType());
            ucDdo.setExpiredTime(uc.getExpiredTime());
            ucDdo.setCid(uc.getCid());
            ucDdo.setPkgId(uc.getPkgId());
            ucDdo.setLastModifyTime(new Date());
            ucDdos.add(ucDdo);
        }
        if (!CollectionUtils.isNullOrEmpty(ucDdos)) {
            this.mfcUserCloudDao.storeAll(ucDdos);
        }
        this.refreshAccount(accountId);
    }

    @Override
    public void clearAccount(long accountId) {
        List<MfcUserCloudDdo> mfcUserClouds = this.mfcUserCloudDao.getUserCloudsByAccount(accountId);
        List<MfcUserCloudPkgDdo> mfcUserCloudPkgs = this.mfcUserCloudDao.getUserCloudPkgsByAccount(accountId);
        ArrayList<TenantAbstractLMI> toDels = new ArrayList<TenantAbstractLMI>();
        if (!CollectionUtils.isNullOrEmpty(mfcUserClouds)) {
            toDels.addAll(mfcUserClouds);
        }
        if (!CollectionUtils.isNullOrEmpty(mfcUserCloudPkgs)) {
            toDels.addAll(mfcUserCloudPkgs);
        }
        this.mfcUserCloudDao.deleteAll(toDels);
        this.refreshAccount(accountId);
    }

    @Override
    public void delUserCloud(MfcUserCloudDdo userCloud) {
        this.delUserClouds(userCloud.getAccountId(), SetTool.asHashSet((Object[])new Long[]{userCloud.getCid()}));
    }

    @Override
    public void delUserClouds(List<MfcUserCloudDdo> userClouds) {
        Map<String, List<MfcUserCloudDdo>> accountMap = this.getAccountCloudsMap(userClouds);
        for (Map.Entry<String, List<MfcUserCloudDdo>> e : accountMap.entrySet()) {
            long accountId = Long.parseLong(e.getKey());
            HashSet<Long> cidSet = new HashSet<Long>();
            if (!CollectionUtils.isNullOrEmpty((Collection)e.getValue())) {
                for (int i = 0; i < e.getValue().size(); ++i) {
                    MfcUserCloudDdo uc = e.getValue().get(i);
                    cidSet.add(uc.getCid());
                }
            }
            this.delUserClouds(accountId, cidSet);
        }
    }

    @Override
    public void delUserClouds(long accountId, Set<Long> cids) {
        if (CollectionUtils.isNullOrEmpty(cids)) {
            return;
        }
        Map<Long, MfcUserCloudDdo> mfcUserCloudDdos = this.mfcUserCloudDao.getUserCloudsByAccountAndCids(accountId, cids);
        if (!CollectionUtils.isNullOrEmpty(mfcUserCloudDdos)) {
            this.mfcUserCloudDao.deleteAll(mfcUserCloudDdos.values());
        }
        this.refreshAccount(accountId);
    }

    @Override
    public List<MfcUserCloudDdo> getUserCloudsByAccount(long accountId) {
        String key = "user-cloud-" + accountId;
        List userClouds = (List)this.cloudRedisCache.get(key);
        if (userClouds != null) {
            return userClouds;
        }
        try {
            RefreshAccountEntity result = this.refreshAccount(accountId);
            return result.getUserClouds();
        }
        catch (Exception ex) {
            logger.error("getUserCloudsByAccount(),exception.", (Throwable)ex);
            return null;
        }
    }

    @Override
    public Map<Long, UserCloudCidSummary> getCidSummaryByAccount(long accountId) {
        String key = "user-cids-" + accountId;
        Set valueSet = (Set)this.cloudRedisCache.get(key);
        if (valueSet != null) {
            return this.cidSummaryService.toObjects(valueSet);
        }
        try {
            RefreshAccountEntity result = this.refreshAccount(accountId);
            List<Long> cidBg = this.getCidBg(result);
            HashMap<Long, UserCloudCidSummary> map = new HashMap<Long, UserCloudCidSummary>();
            if (!CollectionUtils.isNullOrEmpty(result.getMergedUserClouds())) {
                for (int i = 0; i < result.getMergedUserClouds().size(); ++i) {
                    UserCloudCidSummary cidSummary = this.cidSummaryService.toSummary(result.getMergedUserClouds().get(i), cidBg);
                    if (cidSummary == null) continue;
                    map.put(cidSummary.getCid(), cidSummary);
                }
            }
            return map;
        }
        catch (Exception ex) {
            logger.error("getCidSummaryByAccount(),exception.", (Throwable)ex);
            return null;
        }
    }

    private List<Long> getCidBg(RefreshAccountEntity result) {
        List<Long> cids;
        List<Long> bgCids;
        Set<Long> pkgIds;
        List<Long> bgPkgIds;
        ArrayList<Long> cidBg = new ArrayList<Long>();
        List<MfcUserCloudPkgDdo> userCloudPkgs = result.getUserCloudPkgs();
        List<MfcUserCloudDdo> userClouds = result.getUserClouds();
        if (!CollectionUtils.isNullOrEmpty(userCloudPkgs) && !CollectionUtils.isNullOrEmpty(bgPkgIds = this.cloudPkgBgDao.queryBlackList(pkgIds = userCloudPkgs.stream().map(MfcUserCloudPkgDdo::getPkgId).collect(Collectors.toSet())))) {
            List collect;
            HashSet cids2 = new HashSet();
            Map<Long, MfcCloudPkgDto> pkgsByPkgIds = this.cloudPkgCacheService.getCloudPkgsByPkgIds(pkgIds);
            List diff = pkgIds.stream().filter(s -> !bgPkgIds.contains(s)).collect(Collectors.toList());
            for (Long pkgId : bgPkgIds) {
                collect = pkgsByPkgIds.get(pkgId).getMfcCloudPkgDetails().stream().map(MfcCloudPkgDetailDdo::getCid).collect(Collectors.toList());
                cids2.addAll(collect);
            }
            for (Long pkgId : diff) {
                collect = pkgsByPkgIds.get(pkgId).getMfcCloudPkgDetails().stream().map(MfcCloudPkgDetailDdo::getCid).collect(Collectors.toList());
                cids2.removeAll(collect);
            }
            cidBg.addAll(cids2);
        }
        if (!CollectionUtils.isNullOrEmpty(userClouds) && !CollectionUtils.isNullOrEmpty(bgCids = this.cloudAcctBgDao.queryBlackList(cids = userClouds.stream().map(MfcUserCloudDdo::getCid).collect(Collectors.toList())))) {
            cidBg.addAll(bgCids);
        }
        return cidBg;
    }

    @Override
    public Map<Long, MfcUserCloudDdo> getUserCloudsOfCidMapByAccount(long accountId) {
        List<MfcUserCloudDdo> clouds = this.getUserCloudsByAccount(accountId);
        Map<Long, MfcUserCloudDdo> map = new HashMap<Long, MfcUserCloudDdo>();
        if (!CollectionUtils.isNullOrEmpty(clouds)) {
            map = clouds.stream().collect(Collectors.toMap(MfcUserCloudDdo::getCid, cloud -> cloud));
        }
        return map;
    }

    @Override
    public List<MfcUserCloudDdo> getMergedUserCloudsByAccount(long accountId) {
        Map<Long, MfcUserCloudDdo> map = this.getMergedUserCloudsOfCidMapByAccount(accountId);
        return new ArrayList<MfcUserCloudDdo>(map.values());
    }

    private void getUserCloudsAndUserCloudPkgsByAccount(long accountId, List<MfcUserCloudDdo> userClouds, List<MfcUserCloudPkgDdo> userCloudPkgs) {
        String ucKey = "user-cloud-" + accountId;
        String ucpKey = "user-cloud-pkg-" + accountId;
        HashSet<String> keys = new HashSet<String>();
        keys.add(ucKey);
        keys.add(ucpKey);
        Map redisObjs = this.cloudRedisCache.mGet(keys);
        List ucs = null;
        if (redisObjs != null && redisObjs.containsKey(ucKey) && redisObjs.get(ucKey) != null) {
            ucs = (List)redisObjs.get(ucKey);
        }
        List ucps = null;
        if (redisObjs != null && redisObjs.containsKey(ucpKey) && redisObjs.get(ucpKey) != null) {
            ucps = (List)redisObjs.get(ucpKey);
        }
        if (ucs != null && ucps != null) {
            userClouds.clear();
            userCloudPkgs.clear();
            userClouds.addAll(ucs);
            userCloudPkgs.addAll(ucps);
            return;
        }
        try {
            RefreshAccountEntity result = this.refreshAccount(accountId);
            userClouds.clear();
            userCloudPkgs.clear();
            if (!CollectionUtils.isNullOrEmpty(result.getUserClouds())) {
                userClouds.addAll(result.getUserClouds());
            }
            if (!CollectionUtils.isNullOrEmpty(result.getUserCloudPkgs())) {
                userCloudPkgs.addAll(result.getUserCloudPkgs());
            }
        }
        catch (Exception ex) {
            logger.error("getUserCloudsByAccount(),exception.", (Throwable)ex);
        }
    }

    @Override
    public Map<Long, MfcUserCloudDdo> getMergedUserCloudsOfCidMapByAccount(long accountId) {
        ArrayList<MfcUserCloudDdo> userClouds = new ArrayList<MfcUserCloudDdo>();
        ArrayList<MfcUserCloudPkgDdo> userCloudPkgs = new ArrayList<MfcUserCloudPkgDdo>();
        this.getUserCloudsAndUserCloudPkgsByAccount(accountId, userClouds, userCloudPkgs);
        Set<Long> pkgIds = userCloudPkgs.stream().map(MfcUserCloudPkgDdo::getPkgId).collect(Collectors.toSet());
        Map<Long, MfcCloudPkgDto> dtoMap = this.cloudPkgCacheService.getCloudPkgsByPkgIds(pkgIds);
        List<MfcUserCloudDdo> mergedUserClouds = this.merge(accountId, userClouds, userCloudPkgs, dtoMap);
        return mergedUserClouds.stream().collect(Collectors.toMap(MfcUserCloudDdo::getCid, item -> item));
    }

    @Override
    public MfcUserCloudDdo getMergedUserCloudByAccountAndCid(long accountId, long cid) {
        Map<Long, MfcUserCloudDdo> map = this.getMergedUserCloudsOfCidMapByAccount(accountId);
        return map.get(cid);
    }

    @Override
    public Map<Long, MfcCloudPkgDto> getCloudPkgsByAccount(long accountId) {
        List<MfcUserCloudPkgDdo> userCloudPkgs = this.getUserCloudPkgsByAccount(accountId);
        if (userCloudPkgs == null) {
            userCloudPkgs = new ArrayList<MfcUserCloudPkgDdo>();
        }
        Set<Long> pkgIds = userCloudPkgs.stream().map(MfcUserCloudPkgDdo::getPkgId).collect(Collectors.toSet());
        return this.cloudPkgCacheService.getCloudPkgsByPkgIds(pkgIds);
    }

    @Override
    public Map<Long, MfcUserCloudPkgDto> getUserCloudPkgDtosByAccount(long accountId) {
        HashMap<Long, MfcUserCloudPkgDto> map = new HashMap<Long, MfcUserCloudPkgDto>();
        List<MfcUserCloudPkgDdo> userCloudPkgs = this.getUserCloudPkgsByAccount(accountId);
        if (CollectionUtils.isNullOrEmpty(userCloudPkgs)) {
            return map;
        }
        Set<Long> pkgIds = userCloudPkgs.stream().map(MfcUserCloudPkgDdo::getPkgId).collect(Collectors.toSet());
        Map<Long, MfcCloudPkgDto> dtoMap = this.cloudPkgCacheService.getCloudPkgsByPkgIds(pkgIds);
        if (CollectionUtils.isNullOrEmpty(dtoMap)) {
            return map;
        }
        for (MfcUserCloudPkgDdo ucp : userCloudPkgs) {
            MfcCloudPkgDto dto;
            if (!dtoMap.containsKey(ucp.getPkgId()) || (dto = dtoMap.get(ucp.getPkgId())) == null) continue;
            MfcUserCloudPkgDto d = new MfcUserCloudPkgDto();
            d.setMfcUserCloudPkg(ucp);
            d.setMfcCloudPkgDetails(dto.getMfcCloudPkgDetails());
            d.setMfcCloudPkg(dto.getMfcCloudPkg());
            map.put(ucp.getPkgId(), d);
        }
        return map;
    }

    @Override
    public MfcCloudPkgDto getCloudPkgByAccountAndPkgId(long accountId, long pkgId) {
        Map<Long, MfcCloudPkgDto> map = this.getCloudPkgsByAccount(accountId);
        return map.get(pkgId);
    }

    @Override
    public MfcUserCloudDdo getUserCloudsByAccountAndCid(long accountId, long cid) {
        List<MfcUserCloudDdo> userClouds = this.getUserCloudsByAccount(accountId);
        HashMap<Long, MfcUserCloudDdo> cidMap = new HashMap<Long, MfcUserCloudDdo>();
        if (!CollectionUtils.isNullOrEmpty(userClouds)) {
            for (MfcUserCloudDdo userCloud : userClouds) {
                cidMap.put(userCloud.getCid(), userCloud);
            }
        }
        if (cidMap.containsKey(cid)) {
            return (MfcUserCloudDdo)((Object)cidMap.get(cid));
        }
        return null;
    }

    @Override
    public MfcUserCloudPkgDdo getUserCloudPkgsByAccountAndPkgId(long accountId, long pkgId) {
        Map<Long, MfcUserCloudPkgDdo> map = this.getUserCloudPkgsOfPkgIdMapByAccount(accountId);
        return map.get(pkgId);
    }

    @Override
    public List<MfcUserCloudPkgDdo> getUserCloudPkgsByAccount(long accountId) {
        String key = "user-cloud-pkg-" + accountId;
        List userClouds = (List)this.cloudRedisCache.get(key);
        if (userClouds != null) {
            return userClouds;
        }
        try {
            RefreshAccountEntity result = this.refreshAccount(accountId);
            return result.getUserCloudPkgs();
        }
        catch (Exception ex) {
            logger.error("getUserCloudsByAccount(),exception.", (Throwable)ex);
            return null;
        }
    }

    @Override
    public Map<Long, MfcUserCloudPkgDdo> getUserCloudPkgsOfPkgIdMapByAccount(long accountId) {
        HashMap<Long, MfcUserCloudPkgDdo> map = new HashMap<Long, MfcUserCloudPkgDdo>();
        List<MfcUserCloudPkgDdo> pkgs = this.getUserCloudPkgsByAccount(accountId);
        if (!CollectionUtils.isNullOrEmpty(pkgs)) {
            for (MfcUserCloudPkgDdo pkg : pkgs) {
                map.put(pkg.getPkgId(), pkg);
            }
        }
        return map;
    }

    @Override
    public void setUserCloudPkg(MfcUserCloudPkgDdo userCloudPkg) {
        this.setUserCloudPkgs(ListTool.toList((Object[])new MfcUserCloudPkgDdo[]{userCloudPkg}));
    }

    @Override
    public void setUserCloudPkgs(long accountId, List<MfcUserCloudPkgDdo> userCloudPkgs) {
        if (CollectionUtils.isNullOrEmpty(userCloudPkgs)) {
            return;
        }
        ArrayList<MfcUserCloudPkgDdo> ucDdos = new ArrayList<MfcUserCloudPkgDdo>();
        Set<Long> pkgIds = userCloudPkgs.stream().map(MfcUserCloudPkgDdo::getPkgId).collect(Collectors.toSet());
        Map<Long, MfcUserCloudPkgDdo> ucMap = this.mfcUserCloudDao.getUserCloudPkgsByAccountAndPkgIds(accountId, pkgIds);
        for (MfcUserCloudPkgDdo uc : userCloudPkgs) {
            MfcUserCloudPkgDdo ucDdo = (MfcUserCloudPkgDdo)((Object)MapTool.get(ucMap, (Object)uc.getPkgId()));
            if (ucDdo == null) {
                ucDdo = new MfcUserCloudPkgDdo();
            }
            ucDdo.setAccountId(accountId);
            ucDdo.setPkgId(uc.getPkgId());
            ucDdo.setExpiredTime(uc.getExpiredTime());
            ucDdo.setLastModifyTime(new Date());
            ucDdos.add(ucDdo);
        }
        if (!CollectionUtils.isNullOrEmpty(ucDdos)) {
            this.mfcUserCloudDao.storeAll(ucDdos);
        }
        this.refreshAccount(accountId);
    }

    private Map<String, List<MfcUserCloudPkgDdo>> getAccountCloudPkgMap(List<MfcUserCloudPkgDdo> userCloudPkgs) {
        HashMap<String, List<MfcUserCloudPkgDdo>> result = new HashMap<String, List<MfcUserCloudPkgDdo>>();
        if (CollectionUtils.isNullOrEmpty(userCloudPkgs)) {
            return result;
        }
        for (MfcUserCloudPkgDdo uc : userCloudPkgs) {
            List<MfcUserCloudPkgDdo> list;
            String key = String.valueOf(uc.getAccountId());
            if (result.containsKey(key)) {
                list = (List)result.get(key);
            } else {
                list = new ArrayList();
                result.put(key, list);
            }
            list.add(uc);
        }
        return result;
    }

    @Override
    public void setUserCloudPkgs(List<MfcUserCloudPkgDdo> userCloudPkgs) {
        if (CollectionUtils.isNullOrEmpty(userCloudPkgs)) {
            return;
        }
        Map<String, List<MfcUserCloudPkgDdo>> accountMap = this.getAccountCloudPkgMap(userCloudPkgs);
        for (Map.Entry<String, List<MfcUserCloudPkgDdo>> e : accountMap.entrySet()) {
            String key = e.getKey();
            long accountId = Long.parseLong(key);
            List<MfcUserCloudPkgDdo> ucPkgs = e.getValue();
            this.setUserCloudPkgs(accountId, ucPkgs);
        }
    }

    @Override
    public void delUserCloudPkg(MfcUserCloudPkgDdo userCloudPkg) {
        this.delUserCloudPkgs(ListTool.toList((Object[])new MfcUserCloudPkgDdo[]{userCloudPkg}));
    }

    @Override
    public void delUserCloudPkgs(long accountId, Set<Long> pkgIds) {
        Map<Long, MfcUserCloudPkgDdo> pkgMap = this.mfcUserCloudDao.getUserCloudPkgsByAccountAndPkgIds(accountId, pkgIds);
        ArrayList<MfcUserCloudPkgDdo> pkgs = new ArrayList<MfcUserCloudPkgDdo>(pkgMap.values());
        if (pkgs.size() != 0) {
            this.mfcUserCloudDao.deleteAll(pkgs);
        }
        this.refreshAccount(accountId);
    }

    @Override
    public void delUserCloudPkgs(List<MfcUserCloudPkgDdo> userCloudPkgs) {
        if (CollectionUtils.isNullOrEmpty(userCloudPkgs)) {
            return;
        }
        Map<String, List<MfcUserCloudPkgDdo>> accountMap = this.getAccountCloudPkgMap(userCloudPkgs);
        for (Map.Entry<String, List<MfcUserCloudPkgDdo>> e : accountMap.entrySet()) {
            String key = e.getKey();
            String[] items = key.split("_");
            long accountId = Long.parseLong(items[0]);
            Set<Long> pkgIds = e.getValue().stream().map(MfcUserCloudPkgDdo::getPkgId).collect(Collectors.toSet());
            this.delUserCloudPkgs(accountId, pkgIds);
        }
    }

    @Override
    public MfcUserCloudDdo getUserCloudsByAccountAndCidAndAccType(long accountId, long cid, boolean onlyPrivate) {
        List<MfcUserCloudDdo> userClouds = this.getUserCloudsByAccount(accountId);
        HashMap<Long, MfcUserCloudDdo> cidMap = new HashMap<Long, MfcUserCloudDdo>();
        if (!CollectionUtils.isNullOrEmpty(userClouds)) {
            for (MfcUserCloudDdo userCloud : userClouds) {
                cidMap.put(userCloud.getCid(), userCloud);
            }
        }
        if (cidMap.containsKey(cid)) {
            MfcUserCloudDdo userCloud = (MfcUserCloudDdo)((Object)cidMap.get(cid));
            if (onlyPrivate) {
                if (userCloud.getAcctType() == ECloudAcctType.PRIVATE.ordinal()) {
                    return userCloud;
                }
            } else {
                return userCloud;
            }
        }
        return null;
    }

    @Override
    public void resetClouds(Set<Long> accountIds, List<MfcUserCloudDdo> mfcUserClouds, List<MfcUserCloudPkgDdo> mfcUserCloudPkgs, Map<Long, List<MfcUserCloudDdo>> newUserClouds, Map<Long, List<MfcUserCloudPkgDdo>> newUserCloudPkgs) {
        ArrayList<TenantAbstractLMI> toDels = new ArrayList<TenantAbstractLMI>();
        toDels.addAll(mfcUserClouds);
        toDels.addAll(mfcUserCloudPkgs);
        if (toDels.size() != 0) {
            this.mfcUserCloudDao.deleteAll(toDels);
        }
        ArrayList toAdds = new ArrayList();
        for (Map.Entry<Long, List<MfcUserCloudDdo>> entry : newUserClouds.entrySet()) {
            toAdds.addAll(entry.getValue());
        }
        for (Map.Entry<Long, List<TenantAbstractLMI>> entry : newUserCloudPkgs.entrySet()) {
            toAdds.addAll(entry.getValue());
        }
        if (toAdds.size() != 0) {
            this.mfcUserCloudDao.storeAll(toAdds);
        }
        this.clearAccountCaches(accountIds);
    }

    private void clearAccountCaches(Set<Long> accountIds) {
        HashSet<String> keys = new HashSet<String>();
        for (Long accountId : accountIds) {
            String key = "user-cloud-" + accountId;
            keys.add(key);
            String pkgKey = "user-cloud-pkg-" + accountId;
            keys.add(pkgKey);
            String ucKey = "user-cids-" + accountId;
            keys.add(ucKey);
        }
        this.cloudRedisCache.del(keys.toArray(new String[0]));
    }

    private RefreshAccountEntity refreshAccount(long accountId) {
        RefreshAccountEntity entity = new RefreshAccountEntity();
        try {
            List<MfcUserCloudDdo> userCloudsOfDb = this.getCloudByAccountByDb(accountId);
            List<MfcUserCloudPkgDdo> userCloudPkgsOfDb = this.getCloudPkgByAccountByDb(accountId);
            this.setUserCloudRedis(accountId, userCloudsOfDb, userCloudPkgsOfDb, entity);
            entity.setUserClouds(userCloudsOfDb);
            entity.setUserCloudPkgs(userCloudPkgsOfDb);
        }
        catch (Exception ex) {
            logger.error("refreshAccount(),exception.{}", (Throwable)ex);
        }
        return entity;
    }

    private void setUserCloudRedis(long accountId, List<MfcUserCloudDdo> userClouds, List<MfcUserCloudPkgDdo> userCloudPkgs, RefreshAccountEntity entity) {
        if (userClouds == null) {
            return;
        }
        try {
            String key = "user-cloud-" + accountId;
            long expiredTime = ConfigTools3.getLong((String)"mfc.cloudapi.refreshUserCloud.periodSeconds", (Long)14400L);
            this.cloudRedisCache.setEx(key, userClouds, expiredTime);
            String pkgKey = "user-cloud-pkg-" + accountId;
            long pkgExpiredTime = ConfigTools3.getLong((String)"mfc.cloudapi.refreshUserCloudPkg.periodSeconds", (Long)14400L);
            this.cloudRedisCache.setEx(pkgKey, userCloudPkgs, pkgExpiredTime);
            Set<Long> pkgIds = userCloudPkgs.stream().map(MfcUserCloudPkgDdo::getPkgId).collect(Collectors.toSet());
            Map<Long, MfcCloudPkgDto> cloudPkgsOfDb = this.getCloudPkgsByPkgIdByDb(pkgIds);
            List<MfcUserCloudDdo> mergedClouds = this.merge(accountId, userClouds, userCloudPkgs, cloudPkgsOfDb);
            String ucKey = "user-cids-" + accountId;
            long ucExpiredTime = ConfigTools3.getLong((String)"mfc.cloudapi.refreshUserCids.periodSeconds", (Long)14400L);
            Set<String> cidSummarySet = this.cidSummaryService.toString(mergedClouds);
            this.cloudRedisCache.setEx(ucKey, cidSummarySet, ucExpiredTime);
            entity.setCloudPkgs(cloudPkgsOfDb);
            entity.setMergedUserClouds(mergedClouds);
        }
        catch (Exception ex) {
            logger.error("setUserCloudRedis(),exception.", (Throwable)ex);
        }
    }

    private List<MfcUserCloudDdo> merge(long accountId, List<MfcUserCloudDdo> userClouds, List<MfcUserCloudPkgDdo> userCloudPkgs, Map<Long, MfcCloudPkgDto> cloudPkgs) {
        ArrayList<MfcUserCloudDdo> ucs = new ArrayList<MfcUserCloudDdo>();
        if (userCloudPkgs != null && cloudPkgs != null) {
            for (MfcUserCloudPkgDdo mfcUserCloudPkgDdo : userCloudPkgs) {
                MfcCloudPkgDto mfcCloudPkgDto = cloudPkgs.get(mfcUserCloudPkgDdo.getPkgId());
                if (mfcCloudPkgDto == null || mfcCloudPkgDto.getMfcCloudPkg() == null || CollectionUtils.isNullOrEmpty(mfcCloudPkgDto.getMfcCloudPkgDetails())) continue;
                MfcCloudPkgDdo pkg = mfcCloudPkgDto.getMfcCloudPkg();
                int acctType = 0;
                List<VendorCloudPkgDdo> vendorPkgs = this.vendorCloudPkgCache.getVendorCloudPkgsByPkg(pkg.getId());
                if (CollectionUtils.isNullOrEmpty(vendorPkgs)) {
                    acctType = 1;
                }
                for (int j = 0; j < mfcCloudPkgDto.getMfcCloudPkgDetails().size(); ++j) {
                    MfcUserCloudDdo uc = new MfcUserCloudDdo();
                    MfcCloudPkgDetailDdo d = mfcCloudPkgDto.getMfcCloudPkgDetails().get(j);
                    uc.setAccountId(accountId);
                    uc.setCid(d.getCid());
                    uc.setExpiredTime(mfcUserCloudPkgDdo.getExpiredTime());
                    uc.setAcctAlias(d.getAcctAlias());
                    uc.setAcctType(acctType);
                    ucs.add(uc);
                }
            }
        }
        if (userClouds != null) {
            ucs.addAll(userClouds);
        }
        HashMap cloudMap = new HashMap();
        for (MfcUserCloudDdo mfcUserCloudDdo : ucs) {
            List<MfcUserCloudDdo> clouds;
            if (cloudMap.containsKey(mfcUserCloudDdo.getCid())) {
                clouds = (List)cloudMap.get(mfcUserCloudDdo.getCid());
            } else {
                clouds = new ArrayList();
                cloudMap.put(mfcUserCloudDdo.getCid(), clouds);
            }
            clouds.add(mfcUserCloudDdo);
        }
        for (Map.Entry entry : cloudMap.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            ((List)entry.getValue()).sort((m1, m2) -> {
                long exp2;
                long exp1 = m1.getExpiredTime() == null ? 0L : m1.getExpiredTime();
                long l = exp2 = m2.getExpiredTime() == null ? 0L : m2.getExpiredTime();
                if (exp1 == 0L) {
                    exp1 = Long.MAX_VALUE;
                }
                if (exp2 == 0L) {
                    exp2 = Long.MAX_VALUE;
                }
                if (exp1 > exp2) {
                    return -1;
                }
                if (exp1 < exp2) {
                    return 1;
                }
                String alias1 = m1.getAcctAlias() == null ? "" : m1.getAcctAlias();
                String alias2 = m2.getAcctAlias() == null ? "" : m2.getAcctAlias();
                return alias1.compareTo(alias2);
            });
        }
        ArrayList<MfcUserCloudDdo> arrayList = new ArrayList<MfcUserCloudDdo>();
        for (Map.Entry e : cloudMap.entrySet()) {
            arrayList.add((MfcUserCloudDdo)((Object)((List)e.getValue()).get(0)));
        }
        return arrayList;
    }

    private Map<String, List<MfcUserCloudDdo>> getAccountCloudsMap(List<MfcUserCloudDdo> userClouds) {
        HashMap<String, List<MfcUserCloudDdo>> accountMap = new HashMap<String, List<MfcUserCloudDdo>>();
        for (MfcUserCloudDdo uc : userClouds) {
            List<MfcUserCloudDdo> clouds;
            String key = String.valueOf(uc.getAccountId());
            if (accountMap.containsKey(key)) {
                clouds = (List)accountMap.get(key);
            } else {
                clouds = new ArrayList();
                accountMap.put(key, clouds);
            }
            clouds.add(uc);
        }
        return accountMap;
    }

    private List<MfcUserCloudDdo> getCloudByAccountByDb(long accountId) {
        try {
            List<MfcUserCloudDdo> userClouds = this.mfcUserCloudDao.getUserCloudsByAccount(accountId);
            if (userClouds == null) {
                userClouds = new ArrayList<MfcUserCloudDdo>();
            }
            return userClouds;
        }
        catch (Exception ex) {
            logger.error("getCloudByAccountByDb(),exception.", (Throwable)ex);
            throw ex;
        }
    }

    private List<MfcUserCloudPkgDdo> getCloudPkgByAccountByDb(long accountId) {
        try {
            List<MfcUserCloudPkgDdo> userClouds = this.mfcUserCloudDao.getUserCloudPkgsByAccount(accountId);
            if (userClouds == null) {
                userClouds = new ArrayList<MfcUserCloudPkgDdo>();
            }
            return userClouds;
        }
        catch (Exception ex) {
            logger.error("getCloudPkgByAccountByDb(),exception.", (Throwable)ex);
            throw ex;
        }
    }

    private Map<Long, MfcCloudPkgDto> getCloudPkgsByPkgIdByDb(Set<Long> pkgIds) {
        try {
            return this.cloudPkgCacheService.getCloudPkgsByPkgIds(pkgIds);
        }
        catch (Exception ex) {
            logger.error("getCloudPkgsByPkgIdByDb(),exception.", (Throwable)ex);
            throw ex;
        }
    }
}

