package com.valor.vod.cloud.blackGrey;

import com.valor.vod.cloud.model.database.dao.CloudBaseDao;
import com.valor.vod.cloud.model.database.ddo.CloudAcctBgDdo;
import common.base.tools.type.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author clovis
 * @date 2022/11/11
 */
@Repository
@Transactional(value = "cloudTransactionManager")
public class CloudAcctBgDao extends CloudBaseDao {
    @Autowired
    protected SessionFactory cloudSessionFactory;

    @Override
    @Transactional("cloudTransactionManager")
    public Session currentSession() {
        return this.cloudSessionFactory.getCurrentSession();
    }

    /**
     * 查询cloud account数量
     */
    public long count(String account, Integer type) {
        Criteria criteria = currentSession().createCriteria(CloudAcctBgDdo.class);
        if (StringUtils.isNotBlank(account)) {
            criteria.add(Restrictions.eq("loginId", account.trim()));
        }
        if (type != null) {
            criteria.add(Restrictions.eq("type", "%" + type));
        }
        criteria.setProjection(Projections.rowCount());
        return (long) criteria.uniqueResult();
    }

    /**
     * 查询cloud account列表
     */
    @Transactional("cloudTransactionManager")
    public List<CloudAcctBgDdo> list(String account, Integer type, int start, int size) {
        Criteria criteria = currentSession().createCriteria(CloudAcctBgDdo.class);
        if (StringUtils.isNotBlank(account)) {
            criteria.add(Restrictions.eq("loginId", account.trim()));
        }
        if (type != null) {
            criteria.add(Restrictions.eq("type", type));
        }
        criteria.setFirstResult(start);
        criteria.setMaxResults(size);
        List<CloudAcctBgDdo> results = criteria.list();
        if (CollectionUtils.isNullOrEmpty(results)) {
            return new ArrayList<>();
        }
        return results;
    }

    /**
     * 查询cloud account
     */
    @Transactional("cloudTransactionManager")
    public List<CloudAcctBgDdo> queryList(List<Long> cids) {
        Criteria criteria = currentSession().createCriteria(CloudAcctBgDdo.class);
        criteria.add(Restrictions.in("cid", cids));
        List<CloudAcctBgDdo> results = criteria.list();
        if (CollectionUtils.isNullOrEmpty(results)) {
            return new ArrayList<>();
        }
        return results;
    }

    /**
     * 查询网盘黑名单
     */
    public List<Long> queryBlackList(List<Long> cids) {
        if (CollectionUtils.isNullOrEmpty(cids)) {
            return new ArrayList<>();
        }
        Criteria criteria = currentSession().createCriteria(CloudAcctBgDdo.class);
        criteria.add(Restrictions.in("cid", cids));
        criteria.add(Restrictions.eq("type", 0));
        criteria.add(Restrictions.eq("status", 0));
        List<CloudAcctBgDdo> results = criteria.list();
        if (CollectionUtils.isNullOrEmpty(results)) {
            return new ArrayList<>();
        }
        return results.stream().map(CloudAcctBgDdo::getCid).collect(Collectors.toList());
    }

    /**
     * 查询网盘黑灰名单
     */
    public List<CloudAcctBgDdo> queryValidList(List<Long> cids) {
        if (CollectionUtils.isNullOrEmpty(cids)) {
            return new ArrayList<>();
        }
        Criteria criteria = currentSession().createCriteria(CloudAcctBgDdo.class);
        criteria.add(Restrictions.in("cid", cids));
        criteria.add(Restrictions.eq("status", 0));
        List<CloudAcctBgDdo> results = criteria.list();
        if (CollectionUtils.isNullOrEmpty(results)) {
            return new ArrayList<>();
        }
        return results;
    }
}
