package com.valor.vod.cloud.mfcusercloud;


import com.valor.vod.api.common.MapTool;
import com.valor.vod.cloud.model.database.ddo.VendorCloudPkgDdo;
import common.config.tools.config.ConfigTools3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@Service
public class VendorCloudPkgCache {
    private static final Logger logger = LoggerFactory.getLogger(VendorCloudPkgCache.class);
    @Autowired
    MfcUserCloudDao mfcUserCloudDao;

    private ScheduledExecutorService refreshExecutor = Executors.newScheduledThreadPool(2);

    List<VendorCloudPkgDdo> vendorCloudPkgs = new ArrayList<>();
    Map<Long,List<VendorCloudPkgDdo>> pkgVendorCloudPkgs = new HashMap<>();
    Map<Long,List<VendorCloudPkgDdo>> vendorVendorCloudPkgs = new HashMap<>();

    @PostConstruct
    public void init(){
        long vendorCloudPeriodSeconds = ConfigTools3.getLong("mfc.cloudapi.vendorCloudPkg.periodSeconds", 300L);
        refreshExecutor.scheduleAtFixedRate(new Runnable() {
            @Override
            public void run() {
                try {
                    load();
                }
                catch (Exception ex){
                    logger.error("do refresh VendorCloudPkgCache exception.{}",ex);
                }
            }
        }, 0, vendorCloudPeriodSeconds, TimeUnit.SECONDS);
    }

    private void load(){
        List<VendorCloudPkgDdo> configs = mfcUserCloudDao.getListData(false, VendorCloudPkgDdo.class,null);
        vendorCloudPkgs = configs;
        Map<Long,List<VendorCloudPkgDdo>> vendorCloudMap1 = new HashMap<>();
        Map<Long,List<VendorCloudPkgDdo>> vendorCloudMap2 = new HashMap<>();
        if (vendorCloudPkgs != null){
            for (int i=0;i<vendorCloudPkgs.size();i++){
                VendorCloudPkgDdo vc = vendorCloudPkgs.get(i);
                MapTool.getOrNewArrayList(vendorCloudMap1,vc.getPkgId()).add(vc);
                MapTool.getOrNewArrayList(vendorCloudMap2,vc.getVendorId()).add(vc);
            }
        }
        pkgVendorCloudPkgs = vendorCloudMap1;
        vendorVendorCloudPkgs = vendorCloudMap2;

        logger.info("load(), vendor cloud pkg size:{}",configs.size());
    }

    public List<VendorCloudPkgDdo> getVendorCloudPkgsByPkg(long pkgId){
        return pkgVendorCloudPkgs.getOrDefault(pkgId,new ArrayList<>());
    }

    public List<VendorCloudPkgDdo> getVendorCloudPkgsByVendor(long vendorId){
        return vendorVendorCloudPkgs.getOrDefault(vendorId,new ArrayList<>());
    }

    public VendorCloudPkgDdo getPublicVendorCloudPkg(){
        List<VendorCloudPkgDdo> vs = getVendorCloudPkgsByVendor(0L);
        if (vs.size() == 0){
            return null;
        }
        return vs.get(0);
    }



}
