package com.valor.vod.cloud.model.database.configuration;

import com.google.common.base.Strings;
import com.valor.vod.common.database.tool.configruation.AbstractDBCfgWithHikariCP;
import common.config.tools.config.ConfigAESTools;
import common.config.tools.config.ConfigTools3;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.transaction.PlatformTransactionManager;

import javax.sql.DataSource;
import java.util.List;
import java.util.Properties;

//@Configuration
//@EnableTransactionManagement
public class MFCCloudDBConfiguration extends AbstractDBCfgWithHikariCP {
    public static final String DATABASE_MODEL_BASE_PACKAGE = ConfigTools3.getString("mfc.cloud.db.appendPackagesToScan", "com.valor.vod.cloud.model.database.ddo");//,"com.mfc.cloud.model",com.mfc.cloud.dao1";
    public static final List<String> DATABASE_MODEL_BASE_PACKAGE_LIST = ConfigTools3.getAsList("mfc.cloud.db.appendPackagesToScan", ",");
    private static final Logger LOG = LoggerFactory.getLogger(MFCCloudDBConfiguration.class);
    private static String CRYPT_KEY = ConfigAESTools.getConfigAsString("mfc.cloud.db.crypt.key", "");

    private String host = getDBConfig("mfc.cloud.db.host", CRYPT_KEY);
    private String dbInst = getDBConfig("mfc.cloud.db.inst", CRYPT_KEY);
    private String username = getDBConfig("mfc.cloud.db.user", CRYPT_KEY);
    private String password = getDBConfig("mfc.cloud.db.pass", CRYPT_KEY);
    private String appendPackagesToScan = ConfigAESTools.getString("mfc.cloud.db.appendPackagesToScan");

    private String dialect = ConfigTools3.getString("db.dialect", "org.hibernate.dialect.MySQL5Dialect");
    private String hbm2ddlAuto = ConfigTools3.getString("db.hbm2ddlAuto", "validate");
    private boolean showSql = ConfigTools3.getBoolean("db.stat.showSql", false);
    private boolean useL2Cache = ConfigTools3.getBoolean("db.l2cache.useL2Cache", false);

    private boolean useQueryCache = ConfigTools3.getBoolean("db.l2cache.pool.useQueryCache", false);
    private String l2CacheFactory = ConfigTools3.getString("db.l2cache.l2CacheFactory", "org.hibernate.cache.ehcache.EhCacheRegionFactory");

    private String mysqlURLExtend = ConfigTools3.getString("mfc.db.mysql.url.extend", "useUnicode=true&characterEncoding=utf8&autoReconnect=true&useSSL=false");

    private String getConnectUrl() {
        if (Strings.isNullOrEmpty(host)
            || Strings.isNullOrEmpty(dbInst)
            || Strings.isNullOrEmpty(username)
            || Strings.isNullOrEmpty(password)) {
            LOG.error("==host,dbInst,username,password ={}-{}-{}-{}", host, dbInst, username, password);
            throw new IllegalArgumentException("Invalid user db config");
        }

        return new StringBuilder()
            .append("jdbc:mysql://")
            .append(host).append("/")
            .append(dbInst)
            .append("?")
            .append(mysqlURLExtend)
            .toString();
    }

    //@Primary
    @Bean(destroyMethod = "close", name = "cloudDataSource")
    @Qualifier(value = "cloudDataSource")
    public DataSource cloudDataSource() {
        LOG.info("Connect database:{}:{}:{}", host, dbInst, username);
        return getDataSource(getConnectUrl(), username, password);
    }


    @Bean(destroyMethod = "destroy", name = "cloudSessionFactory")
    @Qualifier(value = "cloudSessionFactory")
    public FactoryBean<SessionFactory> userSessionFactory() {

        String[] scanedPackage = new String[DATABASE_MODEL_BASE_PACKAGE_LIST.size()];
        DATABASE_MODEL_BASE_PACKAGE_LIST.toArray(scanedPackage);

        if (Strings.isNullOrEmpty(appendPackagesToScan)) {
            return getSessionFactory(cloudDataSource(), appendPackagesToScan);
        } else {
            LOG.info("=== DATABASE_MODEL_BASE_PACKAGE_LIST == [{}]", scanedPackage.toString());
            return getSessionFactory(cloudDataSource(), scanedPackage);
        }
    }

    @Bean(name = "cloudTransactionManager")
    @Qualifier(value = "cloudTransactionManager")
    public PlatformTransactionManager metaTransactionManager() throws Exception {
        return getTransactionManager(userSessionFactory().getObject(), 1800);
    }

    @Override
    public Properties getDBProperties() {
        Properties props = super.getDBProperties();
        useL2Cache = ConfigTools3.getBoolean("db.l2cache.useL2Cache", false);
        props.put("hibernate.dialect", dialect);
        props.put("hibernate.cache.use_second_level_cache", useL2Cache);
        props.put("hibernate.show_sql", showSql);
        if (useL2Cache) {
            props.put("hibernate.cache.region.factory_class", l2CacheFactory);
            props.put("hibernate.cache.use_query_cache", useQueryCache);
        }
        props.put("hibernate.hbm2ddl.auto", hbm2ddlAuto);

        LOG.info("===hibernate useL2Cache=[{}]/ hbm2ddlAuto=[{}]", useL2Cache, hbm2ddlAuto);
        return props;
    }

    /*

    @Override
    public Properties getDBProperties() {
        Properties props = new Properties();
        props.put("hibernate.dialect", dialect);
       // props.put("hibernate.show_sql", showSql);
        props.put("hibernate.show_sql", true);
        props.put("hibernate.generate_statistics", generateStatistics);
        props.put("hibernate.hbm2ddl.auto", ConfigTools3.getConfigAsString("mfc.account.db.auto",hbm2ddlAuto));
        props.put("hibernate.connection.isolation", TRANSACTION_READ_COMMITTED);
        props.put("hibernate.use_sql_comments", true);


        props.put("hibernate.connection.CharSet", "utf8");
        props.put("hibernate.connection.characterEncoding", "utf8");
        props.put("hibernate.connection.useUnicode", false);
        props.put("hibernate.autoReconnect", true);

        props.put("hibernate.cache.use_second_level_cache", false);
        props.put("hibernate.cache.use_query_cache", false);

        return props;
    }
*/
    @Override
    public FactoryBean<SessionFactory> getSessionFactory(@Qualifier("cloudDataSource") DataSource dataSource, String... scanPackages) {
        return super.getSessionFactory(dataSource, scanPackages);


    }


    @Override
    public PlatformTransactionManager getTransactionManager(@Qualifier("cloudSessionFactory") SessionFactory sessionFactory, int txTimeout) throws Exception {
        return super.getTransactionManager(sessionFactory, txTimeout);
    }
}

