package com.valor.vod.cloud.model.database.ddo;

import com.valor.vod.common.database.model.AbstractLMI;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;


@Entity
@Table(
    name = "vms_config"
)
public class MFCConfiguration extends AbstractLMI {
    private static final long serialVersionUID = -3985190780763596771L;
    @Id
    @Column(
        name = "config_key",
        nullable = false,
        length = 255
    )
    private String key;
    @Column(
        name = "config_value",
        length = 2048
    )
    private String value;

    public MFCConfiguration() {
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int hashCode() {
        return (new HashCodeBuilder()).append(this.getKey()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MFCConfiguration) {
            MFCConfiguration other = (MFCConfiguration) obj;
            return (new EqualsBuilder()).append(this.getKey(), other.getKey()).isEquals();
        } else {
            return false;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MFCConfiguration [Key='");
        sb.append(this.getKey());
        sb.append("', value='");
        sb.append(this.getValue());
        sb.append("']");
        return sb.toString();
    }
}