/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.cloud.mfcusercloud;

import com.valor.vod.cloud.mfcusercloud.UserCloudCidSummary;
import com.valor.vod.cloud.model.database.ddo.MfcUserCloudDdo;
import com.valor.vod.common.tools.type.CollectionUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class CidSummaryService {
    public Set<String> toString(List<MfcUserCloudDdo> userClouds) {
        HashSet<String> cidSet = new HashSet<String>();
        if (userClouds == null) {
            return cidSet;
        }
        for (int i = 0; i < userClouds.size(); ++i) {
            MfcUserCloudDdo uc = userClouds.get(i);
            UserCloudCidSummary cidSummary = this.toSummary(uc, Collections.emptyList());
            if (cidSummary == null) continue;
            String cs = this.toCidSummaryValue(cidSummary);
            cidSet.add(cs);
        }
        return cidSet;
    }

    public UserCloudCidSummary toSummary(MfcUserCloudDdo userCloud, List<Long> cidBg) {
        if (userCloud == null) {
            return null;
        }
        UserCloudCidSummary summary = new UserCloudCidSummary();
        Long cid = userCloud.getCid();
        summary.setCid(cid);
        summary.setAcctAlias(userCloud.getAcctAlias());
        summary.setAcctType(userCloud.getAcctType());
        summary.setExpiredTime(userCloud.getExpiredTime());
        if (!CollectionUtils.isNullOrEmpty(cidBg)) {
            summary.setType(cidBg.contains(cid) ? 1 : 0);
        }
        return summary;
    }

    public Map<Long, UserCloudCidSummary> toObjects(Set<String> valueSet) {
        HashMap<Long, UserCloudCidSummary> map = new HashMap<Long, UserCloudCidSummary>();
        for (String value : valueSet) {
            UserCloudCidSummary summary;
            if (value.startsWith("V2_")) {
                summary = this.getUserCloudCidSummaryV2(value);
                if (summary == null) continue;
                map.put(summary.getCid(), summary);
                continue;
            }
            summary = this.getUserCloudCidSummaryV1(value);
            if (summary == null) continue;
            map.put(summary.getCid(), summary);
        }
        return map;
    }

    private UserCloudCidSummary getUserCloudCidSummaryV1(String value) {
        String[] kv = value.split("_", -1);
        if (kv.length < 4) {
            return null;
        }
        UserCloudCidSummary summary = new UserCloudCidSummary();
        summary.setCid(Long.parseLong(kv[0]));
        summary.setAcctType(Integer.parseInt(kv[1]));
        summary.setExpiredTime(Long.parseLong(kv[2]));
        if (kv.length == 4) {
            summary.setAcctAlias(kv[3]);
        } else {
            StringBuilder aSb = new StringBuilder();
            for (int i = 3; i < kv.length; ++i) {
                if (i != 3) {
                    aSb.append("_");
                }
                aSb.append(kv[i]);
            }
            String alias = aSb.toString();
            summary.setAcctAlias(alias);
        }
        return summary;
    }

    private UserCloudCidSummary getUserCloudCidSummaryV2(String value) {
        String[] kv = value.split("_", -1);
        if (kv.length < 6) {
            return null;
        }
        UserCloudCidSummary summary = new UserCloudCidSummary();
        summary.setCid(Long.parseLong(kv[1]));
        summary.setAcctType(Integer.parseInt(kv[2]));
        summary.setExpiredTime(Long.parseLong(kv[3]));
        summary.setType(Integer.parseInt(kv[4]));
        if (kv.length == 6) {
            summary.setAcctAlias(kv[5]);
        } else {
            StringBuilder aSb = new StringBuilder();
            for (int i = 5; i < kv.length; ++i) {
                if (i != 5) {
                    aSb.append("_");
                }
                aSb.append(kv[i]);
            }
            String alias = aSb.toString();
            summary.setAcctAlias(alias);
        }
        return summary;
    }

    private String toCidSummaryValue(UserCloudCidSummary cidSummary) {
        String alias = cidSummary.getAcctAlias() == null ? "" : cidSummary.getAcctAlias();
        long expiredTime = cidSummary.getExpiredTime() == null ? 0L : cidSummary.getExpiredTime();
        int acctType = cidSummary.getAcctType();
        int type = cidSummary.getType();
        StringBuilder vSb = new StringBuilder();
        vSb.append("V2").append("_").append(cidSummary.getCid()).append("_").append(acctType).append("_").append(expiredTime).append("_").append(type).append("_").append(alias);
        return vSb.toString();
    }
}

