/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.cloud.mfcusercloud;

import com.valor.vod.api.common.MapTool;
import com.valor.vod.cloud.mfcusercloud.MfcUserCloudDao;
import com.valor.vod.cloud.model.database.ddo.VendorCloudPkgDdo;
import common.config.tools.config.ConfigTools3;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VendorCloudPkgCache {
    private static final Logger logger = LoggerFactory.getLogger(VendorCloudPkgCache.class);
    @Autowired
    MfcUserCloudDao mfcUserCloudDao;
    private ScheduledExecutorService refreshExecutor = Executors.newScheduledThreadPool(2);
    List<VendorCloudPkgDdo> vendorCloudPkgs = new ArrayList<VendorCloudPkgDdo>();
    Map<Long, List<VendorCloudPkgDdo>> pkgVendorCloudPkgs = new HashMap<Long, List<VendorCloudPkgDdo>>();
    Map<Long, List<VendorCloudPkgDdo>> vendorVendorCloudPkgs = new HashMap<Long, List<VendorCloudPkgDdo>>();

    @PostConstruct
    public void init() {
        long vendorCloudPeriodSeconds = ConfigTools3.getLong((String)"mfc.cloudapi.vendorCloudPkg.periodSeconds", (Long)300L);
        this.refreshExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    VendorCloudPkgCache.this.load();
                }
                catch (Exception ex) {
                    logger.error("do refresh VendorCloudPkgCache exception.{}", (Throwable)ex);
                }
            }
        }, 0L, vendorCloudPeriodSeconds, TimeUnit.SECONDS);
    }

    private void load() {
        List configs;
        this.vendorCloudPkgs = configs = this.mfcUserCloudDao.getListData(false, VendorCloudPkgDdo.class, null);
        HashMap<Long, List<VendorCloudPkgDdo>> vendorCloudMap1 = new HashMap<Long, List<VendorCloudPkgDdo>>();
        HashMap<Long, List<VendorCloudPkgDdo>> vendorCloudMap2 = new HashMap<Long, List<VendorCloudPkgDdo>>();
        if (this.vendorCloudPkgs != null) {
            for (int i = 0; i < this.vendorCloudPkgs.size(); ++i) {
                VendorCloudPkgDdo vc = this.vendorCloudPkgs.get(i);
                MapTool.getOrNewArrayList(vendorCloudMap1, (Object)vc.getPkgId()).add(vc);
                MapTool.getOrNewArrayList(vendorCloudMap2, (Object)vc.getVendorId()).add(vc);
            }
        }
        this.pkgVendorCloudPkgs = vendorCloudMap1;
        this.vendorVendorCloudPkgs = vendorCloudMap2;
        logger.info("load(), vendor cloud pkg size:{}", (Object)configs.size());
    }

    public List<VendorCloudPkgDdo> getVendorCloudPkgsByPkg(long pkgId) {
        return this.pkgVendorCloudPkgs.getOrDefault(pkgId, new ArrayList());
    }

    public List<VendorCloudPkgDdo> getVendorCloudPkgsByVendor(long vendorId) {
        return this.vendorVendorCloudPkgs.getOrDefault(vendorId, new ArrayList());
    }

    public VendorCloudPkgDdo getPublicVendorCloudPkg() {
        List<VendorCloudPkgDdo> vs = this.getVendorCloudPkgsByVendor(0L);
        if (vs.size() == 0) {
            return null;
        }
        return vs.get(0);
    }
}

