/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.cloud.model.database.configuration;

import com.google.common.base.Strings;
import com.valor.vod.common.database.model.TableShardingParams;
import com.valor.vod.common.database.tool.configruation.AbstractDBCfgWithSharding;
import com.valor.vod.common.database.tool.configruation.AuditInterceptor;
import com.zaxxer.hikari.HikariDataSource;
import common.config.tools.config.ConfigTools3;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;

public class DBConfigurationExampleForSharding
extends AbstractDBCfgWithSharding {
    private final String aes_key = ConfigTools3.getString((String)"mfc.cloud.db.crypt.key");
    private final String DATABASE_MODEL_BASE_PACKAGE = "com.valor.vod.cloud.model";
    private String host = this.getDBConfig("mfc.cloud.db.host", this.aes_key);
    private String inst = this.getDBConfig("mfc.cloud.db.inst", this.aes_key);
    private String user = this.getDBConfig("mfc.cloud.db.user", this.aes_key);
    private String pass = this.getDBConfig("mfc.cloud.db.pass", this.aes_key);
    private String appendPackagesToScan = ConfigTools3.getString((String)"mfc.cloud.db.appendPackagesToScan");
    private String driverClassName = ConfigTools3.getString((String)"db.driverClassName", (String)"com.mysql.jdbc.Driver");
    private String dialect = ConfigTools3.getString((String)"db.dialect", (String)"org.hibernate.dialect.MySQL5Dialect");
    private String validationQuery = ConfigTools3.getString((String)"db.validationQuery", (String)"SELECT 1");
    private String hbm2ddlAuto = ConfigTools3.getString((String)"db.hbm2ddlAuto", (String)"update");
    private boolean showSql = ConfigTools3.getBoolean((String)"db.stat.showSql", (boolean)false);
    private boolean generateStatistics = ConfigTools3.getBoolean((String)"db.stat.generateStatistics", (boolean)false);
    private boolean useL2Cache = ConfigTools3.getBoolean((String)"db.l2cache.useL2Cache", (boolean)false);
    private boolean useQueryCache = ConfigTools3.getBoolean((String)"db.l2cache.pool.useQueryCache", (boolean)false);
    private String l2CacheFactory = ConfigTools3.getString((String)"db.l2cache.l2CacheFactory", (String)"org.hibernate.cache.ehcache.EhCacheRegionFactory");

    protected DataSource createDataSouce() {
        HikariDataSource result = new HikariDataSource();
        result.setDriverClassName(this.driverClassName);
        result.setJdbcUrl(this.getConnectUrl());
        result.setUsername(this.user);
        result.setPassword(this.pass);
        result.setMaximumPoolSize(30);
        return result;
    }

    protected List<TableShardingParams> configureTableShardingParams() {
        ArrayList<TableShardingParams> list = new ArrayList<TableShardingParams>();
        TableShardingParams params = new TableShardingParams("linked_user_cloud", "testdb.linked_user_cloud_${0..127}", "uid", "linked_user_cloud_${uid % 128}");
        list.add(params);
        return list;
    }

    protected String configureDatabaseName() {
        return "testdb";
    }

    private String getConnectUrl() {
        if (Strings.isNullOrEmpty((String)this.host) || Strings.isNullOrEmpty((String)this.inst) || Strings.isNullOrEmpty((String)this.user) || Strings.isNullOrEmpty((String)this.pass)) {
            throw new IllegalArgumentException("Invalid parameter");
        }
        return "jdbc:mysql://" + this.host + "/" + this.inst + "?" + "useUnicode=true&characterEncoding=utf8&autoReconnect=true";
    }

    private Properties getDBProperties() {
        Properties props = this.getHibernateDBProperties();
        this.useL2Cache = ConfigTools3.getBoolean((String)"mfc.cloud.db.useL2Cache", (boolean)false);
        props.put("hibernate.cache.use_second_level_cache", (Object)this.useL2Cache);
        if (this.useL2Cache) {
            props.put("hibernate.cache.region.factory_class", this.l2CacheFactory);
            props.put("hibernate.cache.use_query_cache", (Object)this.useQueryCache);
        }
        props.put("hibernate.hbm2ddl.auto", this.hbm2ddlAuto);
        return props;
    }

    @Bean(name={"cloudSessionFactory"})
    @Primary
    public FactoryBean<SessionFactory> cloudSessionFactory() throws SQLException {
        if (Strings.isNullOrEmpty((String)this.appendPackagesToScan)) {
            return this.getSessionFactory(this.getShardingDataSource(), "com.valor.vod.cloud.model");
        }
        return this.getSessionFactory(this.getShardingDataSource(), "com.valor.vod.cloud.model", this.appendPackagesToScan);
    }

    @Bean(name={"cloudTransactionManager"})
    public PlatformTransactionManager cloudTransactionManager() throws Exception {
        HibernateTransactionManager transactionManager = new HibernateTransactionManager((SessionFactory)this.cloudSessionFactory().getObject());
        transactionManager.setDefaultTimeout(1800);
        return transactionManager;
    }

    private FactoryBean<SessionFactory> getSessionFactory(DataSource dataSource, String ... scanPackages) {
        LocalSessionFactoryBean sessionFactoryBean = new LocalSessionFactoryBean();
        sessionFactoryBean.setEntityInterceptor((Interceptor)new AuditInterceptor());
        sessionFactoryBean.setDataSource(dataSource);
        sessionFactoryBean.setPackagesToScan(scanPackages);
        sessionFactoryBean.setHibernateProperties(this.getDBProperties());
        return sessionFactoryBean;
    }

    private Properties getHibernateDBProperties() {
        Properties props = new Properties();
        props.put("hibernate.dialect", this.dialect);
        props.put("hibernate.show_sql", (Object)this.showSql);
        props.put("hibernate.format_sql", (Object)false);
        props.put("hibernate.generate_statistics", (Object)this.generateStatistics);
        props.put("hibernate.hbm2ddl.auto", this.hbm2ddlAuto);
        props.put("hibernate.connection.isolation", (Object)2);
        props.put("hibernate.use_sql_comments", (Object)true);
        props.put("hibernate.cache.use_second_level_cache", (Object)false);
        props.put("hibernate.cache.use_query_cache", (Object)false);
        props.put("hibernate.connection.CharSet", "utf8");
        props.put("hibernate.connection.characterEncoding", "utf8");
        props.put("hibernate.connection.useUnicode", (Object)true);
        props.put("hibernate.autoReconnect", (Object)true);
        return props;
    }
}

