/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.cloud.model.util;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class IdentifierUtil {
    public static final long BASE_ID = 100000000L;
    public static final int TYPE_MEDIA = 1;
    public static final int TYPE_MIUSC = 2;
    public static final int TYPE_PERSON = 8;
    public static final int TYPE_ADULT = 9;
    public static final String DISPLAY_PREFIX_MEDIA = "mm";
    public static final String DISPLAY_PREFIX_MIUSC = "w";
    public static final String DISPLAY_PREFIX_PERSON = "mp";
    public static final String DISPLAY_PREFIX_ADULT = "aa";
    protected static ImmutableMap<Integer, String> mapTypePrefix = new ImmutableMap.Builder().put((Object)1, (Object)"mm").put((Object)2, (Object)"w").put((Object)8, (Object)"mp").put((Object)9, (Object)"aa").build();
    protected static ImmutableMap<String, Integer> mapPrefixType = new ImmutableMap.Builder().put((Object)"mm", (Object)1).put((Object)"w", (Object)2).put((Object)"mp", (Object)8).put((Object)"aa", (Object)9).build();

    public static String getDisplayId(long internalId) {
        int type = (int)(internalId / 100000000L);
        long sn = internalId - (long)type * 100000000L;
        String prefix = (String)mapTypePrefix.get((Object)type);
        return Strings.nullToEmpty((String)prefix) + Strings.padStart((String)String.valueOf(sn), (int)8, (char)'0');
    }

    public static long getInternalId(String displayId) {
        if (Strings.isNullOrEmpty((String)displayId)) {
            return -1L;
        }
        int type = 0;
        String snStr = "";
        for (Map.Entry entry : mapPrefixType.entrySet()) {
            if (!displayId.startsWith((String)entry.getKey())) continue;
            type = (Integer)entry.getValue();
            snStr = displayId.substring(((String)entry.getKey()).length());
            break;
        }
        if (Strings.isNullOrEmpty((String)snStr)) {
            return -1L;
        }
        long snnum = 0L;
        try {
            snnum = Long.valueOf(snStr);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
        return (long)type * 100000000L + snnum;
    }

    public static long getId(int type, long sn) {
        return (long)type * 100000000L + sn;
    }
}

