/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.cloud.model.util.stat;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.valor.vod.cloud.model.util.stat.StatRangeTools;
import java.util.Map;

public class StatTimeItem {
    private String key = "";
    private long count = 0L;
    private long time = 0L;
    private long max = 0L;
    private long min = 0L;
    private Map<Integer, Long> rangeStat = Maps.newHashMap();

    public Map<Integer, Long> getRanges() {
        return this.rangeStat;
    }

    public void setRanges(Map<Integer, Long> ranges) {
        this.rangeStat = ranges;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public long getCount() {
        return this.count;
    }

    public long getTime() {
        return this.time;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getMax() {
        return this.max;
    }

    public void setMax(long max) {
        this.max = max;
    }

    public long getMin() {
        return this.min;
    }

    public void setMin(long min) {
        this.min = min;
    }

    public Map<Integer, Long> getRangeStat() {
        return this.rangeStat;
    }

    public void setRangeStat(Map<Integer, Long> rangeStat) {
        this.rangeStat = rangeStat;
    }

    public void AddRangeStat(long time) {
        int level = StatRangeTools.getLevel(time);
        long count = this.rangeStat.getOrDefault(level, 0L);
        this.rangeStat.put(level, ++count);
    }

    public void addCount(long count) {
        this.count += count;
    }

    public void addTime(long time) {
        this.time += time;
        if (this.max == 0L && time > this.max) {
            this.max = time;
        }
        if (this.min == 0L || time < this.min) {
            this.min = time;
        }
        this.AddRangeStat(time);
    }

    public long avg() {
        if (this.count == 0L) {
            return 0L;
        }
        return this.time / this.count;
    }

    public String rangeStat() {
        StringBuilder sb = new StringBuilder();
        this.rangeStat.forEach((k, v) -> {
            sb.append("");
            sb.append(Strings.padEnd((String)StatRangeTools.getRangeName(k), (int)10, (char)' '));
            sb.append(":");
            sb.append(Strings.padEnd((String)(v + ""), (int)5, (char)' '));
        });
        return sb.toString();
    }

    public long getCountGELevel(int level) {
        int[] count = new int[]{0};
        this.rangeStat.forEach((k, v) -> {
            if (k >= level) {
                count[0] = (int)((long)count[0] + v);
            }
        });
        return count[0];
    }
}

