package com.valor.vod.cloud.mfcusercloud;

import com.valor.vod.api.common.SetTool;
import com.valor.vod.cloud.cache.CloudRedisCache;
import com.valor.vod.cloud.model.database.ddo.MfcCloudPkgDdo;
import com.valor.vod.cloud.model.database.ddo.MfcCloudPkgDetailDdo;
import com.valor.vod.cloud.model.database.dto.MfcCloudPkgDto;
import com.valor.vod.common.tools.cache.RedisTools;
import com.valor.vod.common.tools.type.CollectionUtils;
import common.config.tools.config.ConfigTools3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.*;
import java.util.stream.Collectors;

//需要重命名
@Service
public class CloudPkgCacheService {
    private static final Logger logger = LoggerFactory.getLogger(CloudPkgCacheService.class);
    //    @Autowired
//    MFCRedisUtil mfcRedisUtil;
    @Autowired
    CloudRedisCache cloudRedisCache;

    @Autowired
    MfcUserCloudDao mfcUserCloudDao;

    GuavaCache pkgCache = null;
    boolean pkgCacheEnabled = true;

    @PostConstruct
    void init() {
        long pkgCacheSeconds = ConfigTools3.getLong("mfc-cloud-pkg-cache-expiredSecends", 300L);
        long pkgCacheSize = ConfigTools3.getLong("mfc-cloud-pkg-cache-maxSize", 20000L);
        pkgCache = new GuavaCache("pkg-cache", pkgCacheSeconds, pkgCacheSize);
        pkgCacheEnabled = ConfigTools3.getBoolean("mfc-cloud-pkg-cache-enabled", true);
    }

//    public MfcCloudPkgDto getCloudPkg(long pkgId){
//        String key = String.valueOf(pkgId);
//        if (pkgCache.exists(key)){
//            return pkgCache.get(key);
//        }
//        MfcCloudPkgDdo pkg = mfcUserCloudDao.getCloudPkg(pkgId);
//        if (pkg == null){
//            pkgCache.set(key,null);
//            return null;
//        }
//
//        List<MfcCloudPkgDetailDdo> details = mfcUserCloudDao.getCloudPkgDetails(pkgId);
//        if (CollectionUtils.isNullOrEmpty(details)){
//            pkgCache.set(key,null);
//            return null;
//        }
//        MfcCloudPkgDto dto = new MfcCloudPkgDto();
//        dto.setMfcCloudPkg(pkg);
//        dto.setMfcCloudPkgDetails(details);
//        pkgCache.set(key,dto);
//        return dto;
//    }

    //    public Map<Long, MfcCloudPkgDto> getCloudPkgs(Set<Long> pkgIds){
//        Map<Long,MfcCloudPkgDto> map = new HashMap<>();
//        for(Long pkgId:pkgIds){
//            MfcCloudPkgDto dto = getCloudPkg(pkgId);
//            map.put(pkgId,dto);
//        }
//        return map;
//    }
    public MfcCloudPkgDto getCloudPkgsByPkgId(Long pkgId) {
        Map<Long, MfcCloudPkgDto> pkgs = getCloudPkgsByPkgIds(SetTool.asHashSet(pkgId));
        return pkgs.getOrDefault(pkgId, null);
    }

    public Map<Long, MfcCloudPkgDto> getCloudPkgsByPkgIds(Set<Long> pkgIds) {
        //简单实现本地cache
        Map<Long, MfcCloudPkgDto> cachePkgs = new LinkedHashMap<>();
        if (pkgCacheEnabled) {
            for (Long pkgId : pkgIds) {
                MfcCloudPkgDto pkg = pkgCache.get(String.valueOf(pkgId));
                if (pkg != null) {
                    cachePkgs.put(pkgId, pkg);
                }
            }
            if (cachePkgs.size() == pkgIds.size()) {
                return cachePkgs;
            }
        }

        long expiredTime = ConfigTools3.getLong("mfc.cloud.pkg.expiredSeconds", 14400L);
        Map<Long, MfcCloudPkgDto> map = RedisTools.gets(cloudRedisCache, "cloud-pkgs-", pkgIds, expiredTime, this::getCloudPkgsByPkgIdByDb);

        if (pkgCacheEnabled) {
            if (!CollectionUtils.isNullOrEmpty(map)) {
                for (Map.Entry<Long, MfcCloudPkgDto> e : map.entrySet()) {
                    if (e.getValue() == null) {
                        continue;
                    }
                    pkgCache.set(String.valueOf(e.getKey()), e.getValue());
                }
            }
        }

        return map;
    }

    private Map<Long, MfcCloudPkgDto> getCloudPkgsByPkgIdByDb(Set<Long> pkgIds) {
        try {
            Map<Long, MfcCloudPkgDto> map = new HashMap<>();
            List<MfcCloudPkgDdo> pkgs = mfcUserCloudDao.getCloudPkgs(pkgIds);
            if (CollectionUtils.isNullOrEmpty(pkgs)) {
                return map;
            }

            List<MfcCloudPkgDetailDdo> details = mfcUserCloudDao.getCloudPkgDetails(pkgIds);
            if (CollectionUtils.isNullOrEmpty(details)) {
                return map;
            }

            Map<Long, List<MfcCloudPkgDetailDdo>> pkgDetailMap = details.stream().collect(Collectors.groupingBy(MfcCloudPkgDetailDdo::getPkgId));

            for (MfcCloudPkgDdo pkg : pkgs) {
                if (!pkgDetailMap.containsKey(pkg.getId())) {
                    continue;
                }
                List<MfcCloudPkgDetailDdo> ds = pkgDetailMap.get(pkg.getId());
                MfcCloudPkgDto dto = new MfcCloudPkgDto();
                dto.setMfcCloudPkg(pkg);
                dto.setMfcCloudPkgDetails(ds);
                map.put(pkg.getId(), dto);
            }
            return map;
        } catch (Exception ex) {
            logger.error("getCloudPkgsByPkgIdByDb(),exception.", ex);
            throw ex;
        }
    }

    public void saveCloudPkg(MfcCloudPkgDdo pkg, List<MfcCloudPkgDetailDdo> details) {
        if (pkg == null || CollectionUtils.isNullOrEmpty(details)) {
            return;
        }
        List<Object> objects = new ArrayList<>();
        objects.add(pkg);
        objects.addAll(details);
        mfcUserCloudDao.storeAll(objects);
        cloudRedisCache.del("cloud-pkgs-" + pkg.getId());
        if (pkgCacheEnabled) {
            pkgCache.del(String.valueOf(pkg.getId()));
        }
    }

    public void setCloudPkgDetails(List<MfcCloudPkgDetailDdo> details) {
        if (CollectionUtils.isNullOrEmpty(details)) {
            return;
        }
        Set<Long> pkgIds = details.stream().map(MfcCloudPkgDetailDdo::getPkgId).collect(Collectors.toSet());
        mfcUserCloudDao.storeAll(details);
        clearPkgCache(pkgIds);
    }

    public void delCloudPkgDetails(List<MfcCloudPkgDetailDdo> details) {
        if (CollectionUtils.isNullOrEmpty(details)) {
            return;
        }
        Set<Long> pkgIds = details.stream().map(MfcCloudPkgDetailDdo::getPkgId).collect(Collectors.toSet());
        mfcUserCloudDao.deleteAll(details);
        clearPkgCache(pkgIds);
    }

    public void clearPkgCache(Set<Long> pkgIds) {
        for (Long pkgId : pkgIds) {
            cloudRedisCache.del("cloud-pkgs-" + pkgId);
            if (pkgCacheEnabled) {
                pkgCache.del(String.valueOf(pkgId));
            }
        }
    }

//    public MfcCloudPkgDto getCloudPkgBySecretKeyByDb(String secretKey){
//        try{
//            MfcCloudPkgDdo pkg = mfcUserCloudDao.getCloudPkgBySecretKey(secretKey);
//            if (pkg == null){
//                return null;
//            }
//
//            List<MfcCloudPkgDetailDdo> details = mfcUserCloudDao.getCloudPkgDetails(pkg.getId());
//            if (CollectionUtils.isNullOrEmpty(details)){
//                return null;
//            }
//
//            MfcCloudPkgDto dto = new MfcCloudPkgDto();
//            dto.setMfcCloudPkg(pkg);
//            dto.setMfcCloudPkgDetails(details);
//
//            return dto;
//        }
//        catch (Exception ex){
//            logger.error("getCloudPkgBySecretKeyByDb(),exception.",ex);
//            throw ex;
//        }
//    }

}
